/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.recommend.engine;

import com.bxm.newidea.dto.MixRecomendResult;
import com.bxm.newidea.param.MixQueryParam;
import com.bxm.newidea.param.MixRecommendParam;
import com.bxm.newidea.recommend.AbstractRecommender;
import com.bxm.newidea.recommend.RecommendManager;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MixRecommendEngine {
    private Logger logger = LoggerFactory.getLogger(MixRecommendEngine.class);
    private RecommendManager recommendManager;

    @Autowired
    public MixRecommendEngine(RecommendManager recommendManager) {
        this.recommendManager = recommendManager;
    }

    public List<MixRecomendResult> recommendMixResult(MixQueryParam mixQueryParam) {
        int num = mixQueryParam.getPageSize();
        Long userId = mixQueryParam.getUserId();
        MixRecommendParam mixRecommendParam = new MixRecommendParam().setAreaCode(mixQueryParam.getAreaCode()).setActionType(mixQueryParam.getActionType()).setPlatform(mixQueryParam.getPlatform()).setUserId(userId);
        List<MixRecomendResult> mixRecommendResultList = new LinkedList<MixRecomendResult>();
        List<AbstractRecommender> recommenderWorkers = this.recommendManager.getMixRecommenders();
        Iterator<AbstractRecommender> iterator = recommenderWorkers.iterator();
        int recommendNum = 0;
        while (iterator.hasNext()) {
            AbstractRecommender recommender = iterator.next();
            int fetchNum = num;
            if (num - recommendNum < fetchNum) {
                fetchNum = num - recommendNum;
            }
            List<MixRecomendResult> results = recommender.recommend(mixRecommendParam.setNum(Integer.valueOf(fetchNum)));
            recommendNum += results.size();
            mixRecommendResultList.addAll(results);
            if (mixRecommendResultList.size() < num) continue;
            break;
        }
        return (mixRecommendResultList = this.removeDuplicateMixResult(mixRecommendResultList)).size() > num ? mixRecommendResultList.subList(0, num) : mixRecommendResultList;
    }

    private List<MixRecomendResult> removeDuplicateMixResult(List<MixRecomendResult> list) {
        return list.stream().distinct().collect(Collectors.toList());
    }
}

