/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.recommend.engine;

import com.alibaba.fastjson.JSONObject;
import com.bxm.newidea.enums.NewsKindEnum;
import com.bxm.newidea.integration.NewsSyncIntegrationService;
import com.bxm.newidea.param.NewsRecommendParam;
import com.bxm.newidea.recommend.AbstractRecommender;
import com.bxm.newidea.recommend.RecommendManager;
import com.bxm.newidea.recommend.filter.RecommendFilter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class NewsRecommendEngine {
    private Logger logger = LoggerFactory.getLogger(NewsRecommendEngine.class);
    private RecommendFilter recommendFilter;
    private RecommendManager recommendManager;
    private NewsSyncIntegrationService newsSyncIntegrationService;

    @Autowired
    public NewsRecommendEngine(RecommendManager recommendManager, RecommendFilter recommendFilter, NewsSyncIntegrationService newsSyncIntegrationService) {
        this.recommendManager = recommendManager;
        this.recommendFilter = recommendFilter;
        this.newsSyncIntegrationService = newsSyncIntegrationService;
    }

    public List<Long> recommendNews(Long userId, Integer kindId, Integer num, String areaCode, Integer curPage) {
        NewsRecommendParam newsRecommendParam = new NewsRecommendParam().setUserId(userId).setNum(num).setAreaCode(areaCode).setCurPage(curPage).setKindId(kindId);
        if (kindId != null && kindId.intValue() == NewsKindEnum.LOCAL.getCode().intValue()) {
            return this.recommendLocalNews(newsRecommendParam);
        }
        if (kindId == null || kindId.equals(NewsKindEnum.RECOMMEND.getCode())) {
            newsRecommendParam.setKindId(null);
            return this.recommendOldHomeNews(newsRecommendParam);
        }
        return this.recommendKindNews(newsRecommendParam);
    }

    private List<Long> recommendKindNews(NewsRecommendParam param) {
        int num = param.getNum();
        Long userId = param.getUserId();
        List<AbstractRecommender> recommenderWorkers = this.recommendManager.getNewsRecommenders();
        List<Long> newsIds = this.getNewsList(recommenderWorkers, param);
        newsIds = this.recommendFilter.newsFilter(newsIds);
        newsIds = this.removeDuplicateNews(newsIds);
        this.newsSyncIntegrationService.generateRecommneded(userId, newsIds);
        return newsIds.size() > num ? newsIds.subList(0, num) : newsIds;
    }

    private List<Long> recommendHomeKindNews(NewsRecommendParam param) {
        int num = param.getNum();
        List<AbstractRecommender> recommenderWorkers = this.recommendManager.getCommonNewsRecommenders();
        List<Long> newsIds = this.getNewsList(recommenderWorkers, param);
        return newsIds.size() > num ? newsIds.subList(0, num) : newsIds;
    }

    private List<Long> recommendOldHomeNews(NewsRecommendParam param) {
        int num = param.getNum();
        Long userId = param.getUserId();
        String areaCode = param.getAreaCode();
        Integer curPage = param.getCurPage();
        Integer kindId = param.getKindId();
        List<Long> commonNewsIds = new LinkedList<Long>();
        NewsRecommendParam localNewsRecommendParam = new NewsRecommendParam().setUserId(userId).setKindId(kindId).setNum(Integer.valueOf(3)).setAreaCode(areaCode).setCurPage(curPage);
        List<Long> localNewsIds = this.recommendLocalNews(localNewsRecommendParam);
        NewsRecommendParam hotNewsRecommendParam = new NewsRecommendParam().setUserId(userId).setKindId(kindId).setNum(Integer.valueOf(2)).setAreaCode(areaCode).setCurPage(curPage);
        List<Long> hotNewsIdList = this.getHotNewsList(hotNewsRecommendParam);
        commonNewsIds.addAll(this.getEachKindNewsList(userId, areaCode, curPage));
        this.interspersedLocalNews(localNewsIds, commonNewsIds);
        if (!CollectionUtils.isEmpty(hotNewsIdList)) {
            commonNewsIds.addFirst(hotNewsIdList.get(0));
        }
        int fetchNum = num - commonNewsIds.size() + 10;
        NewsRecommendParam otherNewsRecommendParam = new NewsRecommendParam().setUserId(userId).setNum(Integer.valueOf(fetchNum)).setAreaCode(areaCode);
        commonNewsIds.addAll(this.recommendHomeKindNews(otherNewsRecommendParam));
        commonNewsIds = this.recommendFilter.newsFilter(commonNewsIds);
        commonNewsIds = commonNewsIds.stream().distinct().limit(num).collect(Collectors.toList());
        this.newsSyncIntegrationService.generateRecommneded(userId, commonNewsIds);
        return commonNewsIds;
    }

    private List<Long> getNewsList(List<AbstractRecommender> recommenderWorkers, NewsRecommendParam newsRecommendParam) {
        LinkedList<Long> newsIds = new LinkedList<Long>();
        Iterator<AbstractRecommender> iterator = recommenderWorkers.iterator();
        int recommendNum = 0;
        while (iterator.hasNext()) {
            AbstractRecommender recommender = iterator.next();
            List<Long> results = this.getRecommendNewsList(recommender, newsRecommendParam, recommendNum);
            recommendNum += results.size();
            newsIds.addAll(results);
            if (newsIds.size() < newsRecommendParam.getNum()) continue;
            break;
        }
        return newsIds;
    }

    private List<Long> getRecommendNewsList(AbstractRecommender recommender, NewsRecommendParam newsRecommendParam, int recommendNum) {
        int fetchNum;
        int num = newsRecommendParam.getNum();
        if (num - recommendNum < (fetchNum = new BigDecimal(num).multiply(new BigDecimal("" + recommender.getWeight())).intValue())) {
            fetchNum = num - recommendNum;
        }
        this.logger.debug("{} \u9884\u8ba1\u63a8\u8350\u6570\u91cf\uff1a{} ", ((Object)((Object)recommender)).getClass(), JSONObject.toJSON((Object)newsRecommendParam));
        newsRecommendParam.setNum(Integer.valueOf(fetchNum + 2));
        List<Long> results = recommender.recommend(newsRecommendParam);
        this.logger.debug("{} \u5b9e\u9645\u63a8\u8350\u6570\u91cf\uff1a{} \u7528\u6237\uff1a{}", new Object[]{((Object)((Object)recommender)).getClass(), results.size(), newsRecommendParam.getUserId()});
        return results;
    }

    private List<Long> getEachKindNewsList(Long userId, String areaCode, int curPage) {
        List<Integer> kindList = this.getKindList(curPage);
        List newsKindList = new ArrayList();
        if (!CollectionUtils.isEmpty(kindList)) {
            newsKindList = this.getStageKindList(kindList).thenCompose(cars -> {
                List<CompletableFuture> kindCompletionStages = kindList.stream().map(kindId -> this.getNewsId(userId, (int)kindId, 1, areaCode)).collect(Collectors.toList());
                CompletableFuture<Void> done = CompletableFuture.allOf(kindCompletionStages.toArray(new CompletableFuture[0]));
                return done.thenApply(v -> kindCompletionStages.stream().map(CompletionStage::toCompletableFuture).map(CompletableFuture::join).collect(Collectors.toList()));
            }).whenComplete((lists, th) -> {
                if (th == null) {
                    this.logger.debug("\u6210\u529f\u901a\u8fc7\u591a\u7ebf\u7a0b\u83b7\u53d6\u591a\u4e2a\u9891\u9053\u7684\u65b0\u95fb:{}", JSONObject.toJSON((Object)lists));
                }
            }).toCompletableFuture().join();
        }
        ArrayList<Long> newsList = new ArrayList<Long>();
        for (List e : newsKindList) {
            newsList.addAll(e);
        }
        return newsList;
    }

    CompletionStage<List<Long>> getNewsId(Long userId, int kindId, int num, String areaCode) {
        NewsRecommendParam newsRecommendParam = new NewsRecommendParam().setAreaCode(areaCode).setNum(Integer.valueOf(num)).setKindId(Integer.valueOf(kindId)).setUserId(userId);
        return CompletableFuture.supplyAsync(() -> this.recommendHomeKindNews(newsRecommendParam));
    }

    private CompletionStage<List<Integer>> getStageKindList(List<Integer> kindList) {
        return CompletableFuture.supplyAsync(() -> kindList);
    }

    private List<Long> getHotNewsList(NewsRecommendParam newsRecommendParam) {
        if (1 == newsRecommendParam.getCurPage()) {
            return this.recommendHotNews(newsRecommendParam);
        }
        return null;
    }

    private List<Integer> getKindList(int curPage) {
        List<Integer> kindList = 1 == curPage ? this.generateHomeKind() : this.generateKind();
        return kindList;
    }

    private void interspersedLocalNews(List<Long> localNewsIds, List<Long> commonNewsIds) {
        if (!CollectionUtils.isEmpty(localNewsIds)) {
            int count = localNewsIds.size();
            int index = 0;
            for (int i = 0; i < count; ++i) {
                if (index > commonNewsIds.size() - 1) {
                    ((LinkedList)commonNewsIds).addLast(localNewsIds.get(i));
                    continue;
                }
                commonNewsIds.add(index, localNewsIds.get(i));
                index += 2;
            }
        }
    }

    private List<Integer> generateKind() {
        ArrayList<Integer> kindList = new ArrayList<Integer>();
        return kindList;
    }

    private List<Integer> generateHomeKind() {
        ArrayList<Integer> kindList = new ArrayList<Integer>();
        kindList.add(20);
        kindList.add(14);
        return kindList;
    }

    private List<Long> recommendLocalNews(NewsRecommendParam newsRecommendParam) {
        AbstractRecommender recommender = this.recommendManager.getLocalNewsRecommender();
        List<Long> results = recommender.recommend(newsRecommendParam);
        return results;
    }

    private List<Long> recommendHotNews(NewsRecommendParam newsRecommendParam) {
        AbstractRecommender recommender = this.recommendManager.getHotNewsRecommender();
        List<Long> results = recommender.recommend(newsRecommendParam);
        return results;
    }

    private List<Long> removeDuplicateNews(List<Long> list) {
        return list.stream().distinct().collect(Collectors.toList());
    }
}

