/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.recommend.handler.forum;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.config.NewsCacheThresholdConfig;
import com.bxm.newidea.constant.RedisKeyConstant;
import com.bxm.newidea.domain.ForumPostMapper;
import com.bxm.newidea.enums.OperationLocationEnum;
import com.bxm.newidea.param.ForumParam;
import com.bxm.newidea.recommend.framework.AbstractForumRecommender;
import com.bxm.newidea.service.ForumService;
import com.bxm.newidea.service.MixRecommendService;
import com.bxm.newidea.vo.CircleNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Deprecated
public class FixForumHomePageRecommender
extends AbstractForumRecommender {
    @Autowired
    private RedisSetAdapter redisSetAdapter;
    @Autowired
    private RedisStringAdapter redisStringAdapter;
    @Autowired
    private ForumPostMapper forumPostMapper;
    @Autowired
    private ForumService forumService;
    @Autowired
    private MixRecommendService mixRecommendService;
    public static HashMap<String, CircleNode[]> postRecommendResults = new HashMap();

    public FixForumHomePageRecommender() {
        super(1.0, 1);
    }

    @Override
    public List<Long> syncRecommend(ForumParam forumParam) {
        long begin = System.currentTimeMillis();
        Long userId = forumParam.getUserId();
        Integer operationId = forumParam.getOperationId();
        KeyGenerator recommendedKey = RedisKeyConstant.FORUM_RECOMMENDED.copy().appendKey((Object)userId).appendKey((Object)OperationLocationEnum.getName((int)operationId)).appendKey((Object)"browsingKey");
        KeyGenerator lastRecommendedKey = RedisKeyConstant.FORUM_RECOMMENDED.copy().appendKey((Object)userId).appendKey((Object)OperationLocationEnum.getName((int)operationId)).appendKey((Object)"lastreadtime");
        KeyGenerator indexKey = RedisKeyConstant.FORUM_RECOMMENDED.copy().appendKey((Object)userId).appendKey((Object)OperationLocationEnum.getName((int)operationId)).appendKey((Object)"index");
        ArrayList<Long> resultList = new ArrayList<Long>();
        int index = this.getInitIndex(forumParam.getUserId(), lastRecommendedKey, indexKey);
        this.logger.info("[syncRecommendPost]\u56fa\u5b9a\u63a8\u8350\u6c60\u6e38\u6807\uff1a{}", (Object)index);
        CircleNode[] postRecommendResultArray = this.getData(forumParam.getAreaCode());
        this.logger.info("[syncRecommendPost]\u56fa\u5b9a\u63a8\u8350\u5e93\u5bb9\u91cf\uff1a{}", (Object)(postRecommendResultArray != null ? postRecommendResultArray.length : 0));
        if (postRecommendResultArray == null || postRecommendResultArray.length == 0) {
            return new ArrayList<Long>();
        }
        this.recommendedFilter(postRecommendResultArray, recommendedKey, indexKey, index, forumParam.getPageSize(), forumParam.getActionType(), resultList, userId, forumParam.getPlatform());
        if (CollectionUtils.isNotEmpty(resultList)) {
            this.redisStringAdapter.set(lastRecommendedKey, (Object)new Date(), (long)NewsCacheThresholdConfig.MIX_EXPIRE_LAST_READ_TIME);
        }
        this.logger.debug("\u540c\u6b65\u63a8\u8350\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - begin));
        return resultList;
    }

    private CircleNode[] getData(String areaCode) {
        List postRecommendResultList;
        CircleNode[] postRecommendResultArray = postRecommendResults.get(areaCode);
        if ((postRecommendResultArray == null || postRecommendResultArray.length == 0) && CollectionUtils.isNotEmpty((Collection)(postRecommendResultList = this.forumPostMapper.selectFixPostList(Integer.valueOf(5000), areaCode)))) {
            postRecommendResultArray = this.forumService.getCircleNode(postRecommendResultList);
            postRecommendResults.put(areaCode, postRecommendResultArray);
        }
        return postRecommendResultArray;
    }

    private void doDownRefresh(CircleNode[] circleNodes, List<Long> resultList, KeyGenerator mixRecordKey, KeyGenerator indexKey, Integer fromIndex, Integer num, Long userId, int plaform) {
        int total = circleNodes.length;
        if (fromIndex >= total) {
            fromIndex = 0;
            this.mixRecommendService.cleanMixCache(userId, plaform);
        }
        int next = fromIndex;
        Set record = this.redisSetAdapter.getAllMembers(mixRecordKey, Long.class);
        for (int i = 0; i < total; ++i) {
            CircleNode circleNode = circleNodes[next];
            this.generateResult(record, mixRecordKey, circleNode, resultList);
            next = circleNode.getNext();
            if (resultList.size() < num) continue;
            this.logger.info("[doDownRefresh]\u5df2\u53d6\u5f97{}\u6761\u6df7\u5408\u63a8\u8350\u6570\u636e\uff0c\u529f\u6210\u5706\u6ee1,\u6e38\u6807\uff1a{}", (Object)num, (Object)next);
            break;
        }
        if (CollectionUtils.isNotEmpty(resultList)) {
            this.redisSetAdapter.add(mixRecordKey, (Object[])resultList.toArray(new Long[0]));
            this.redisSetAdapter.expire(mixRecordKey, (long)NewsCacheThresholdConfig.MIX_EXPIRE_RECOMMENDED_RECORD);
            this.redisStringAdapter.set(indexKey, (Object)next, (long)NewsCacheThresholdConfig.MIX_EXPIRE_FIX_INDEX);
        }
        this.logger.info("[doDownRefresh]\u7ed3\u675f\u904d\u5386,\u6570\u91cf\uff1a{},\u6e38\u6807\uff1a{}", (Object)resultList.size(), (Object)next);
    }

    private void doUpRefresh(CircleNode[] circleNodes, List<Long> resultList, KeyGenerator mixRecordKey, KeyGenerator indexKey, int fromIndex, int num, Long userId, int platfrom) {
        int total = circleNodes.length;
        if (fromIndex >= total) {
            fromIndex = 0;
            this.mixRecommendService.cleanMixCache(userId, platfrom);
        }
        int next = fromIndex;
        Set record = this.redisSetAdapter.getAllMembers(mixRecordKey, Long.class);
        for (int i = 0; i < total; ++i) {
            CircleNode circleNode = circleNodes[next];
            this.generateResult(record, mixRecordKey, circleNode, resultList);
            next = circleNode.getNext();
            if (resultList.size() < num) continue;
            this.logger.info("[doUpRefresh]\u5df2\u53d6\u5f97{}\u6761\u6df7\u5408\u63a8\u8350\u6570\u636e\uff0c\u529f\u6210\u5706\u6ee1", (Object)num);
            break;
        }
        if (CollectionUtils.isNotEmpty(resultList)) {
            this.redisSetAdapter.add(mixRecordKey, (Object[])resultList.toArray(new Long[0]));
            this.redisSetAdapter.expire(mixRecordKey, (long)NewsCacheThresholdConfig.MIX_EXPIRE_RECOMMENDED_RECORD);
        }
        if (next == fromIndex) {
            this.redisStringAdapter.set(indexKey, (Object)0, (long)NewsCacheThresholdConfig.MIX_EXPIRE_FIX_INDEX);
        } else {
            this.redisStringAdapter.set(indexKey, (Object)next, (long)NewsCacheThresholdConfig.MIX_EXPIRE_FIX_INDEX);
        }
        this.logger.info("[doUpRefresh]\u5df2\u53d6\u5f97{}\u6761\u6df7\u5408\u63a8\u8350\u6570\u636e\uff0c\u529f\u6210\u5706\u6ee1", (Object)num);
    }

    private void generateResult(Set<Long> record, KeyGenerator mixRecordKey, CircleNode circleNode, List<Long> resultList) {
        if (!record.contains(circleNode.getId())) {
            resultList.add(circleNode.getId());
            record.add(circleNode.getId());
        }
    }

    protected void recommendedFilter(CircleNode[] circleNodes, KeyGenerator mixRecordKey, KeyGenerator indexKey, Integer fromIndex, Integer num, Integer actionType, List<Long> resultList, Long userId, int platform) {
        if (actionType.equals(1)) {
            this.doDownRefresh(circleNodes, resultList, mixRecordKey, indexKey, fromIndex, num, userId, platform);
        } else if (actionType.equals(2)) {
            this.doUpRefresh(circleNodes, resultList, mixRecordKey, indexKey, fromIndex, num, userId, platform);
        }
    }

    private int getInitIndex(Long userId, KeyGenerator lastRecommendedKey, KeyGenerator indexKey) {
        int index = this.redisStringAdapter.getString(lastRecommendedKey).isEmpty() ? 0 : this.redisStringAdapter.getInt(indexKey);
        return index;
    }
}

