/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.recommend.handler.forum;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.config.NewsCacheThresholdConfig;
import com.bxm.newidea.constant.RedisKeyConstant;
import com.bxm.newidea.domain.ForumPostMapper;
import com.bxm.newidea.enums.OperationLocationEnum;
import com.bxm.newidea.param.ForumParam;
import com.bxm.newidea.param.ForumQueryParam;
import com.bxm.newidea.properties.RecommendProperties;
import com.bxm.newidea.recommend.framework.AbstractForumRecommender;
import com.bxm.newidea.vo.ForumRecommend;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ForumCommonRecommender
extends AbstractForumRecommender {
    private static final Logger logger = LoggerFactory.getLogger(ForumCommonRecommender.class);
    @Autowired
    private RedisSetAdapter redisSetAdapter;
    @Autowired
    private RedisStringAdapter redisStringAdapter;
    @Autowired
    private ForumPostMapper forumPostMapper;
    @Autowired
    private RecommendProperties recommendProperties;

    public ForumCommonRecommender() {
        super(1.0, 1);
    }

    @Override
    public List<Long> syncRecommend(ForumParam forumParam) {
        LinkedList result = Lists.newLinkedList();
        String name = OperationLocationEnum.getName((int)forumParam.getOperationId());
        KeyGenerator shieldRecordKey = RedisKeyConstant.NEWS_SHIELD.copy().appendKey((Object)"detail").appendKey((Object)forumParam.getUserId());
        KeyGenerator shieldUserKey = RedisKeyConstant.NEWS_SHIELD.copy().appendKey((Object)"user").appendKey((Object)forumParam.getUserId());
        KeyGenerator readRecordKey = RedisKeyConstant.FORUM_RECOMMENDED.copy().appendKey((Object)forumParam.getUserId()).appendKey((Object)forumParam.getPlatform()).appendKey((Object)name).appendKey((Object)"already");
        KeyGenerator lastRecommendedKey = RedisKeyConstant.FORUM_RECOMMENDED.copy().appendKey((Object)forumParam.getUserId()).appendKey((Object)forumParam.getPlatform()).appendKey((Object)name).appendKey((Object)"last");
        HashSet readRecordList = Sets.newHashSet();
        readRecordList.addAll(this.redisSetAdapter.getAllMembers(shieldRecordKey, Long.class));
        Set shieldUserList = this.redisSetAdapter.getAllMembers(shieldUserKey, Long.class);
        String lastRecommendedTime = "";
        LinkedList<Object> recommendList = new LinkedList();
        if (null == forumParam.getActionType() || 1 == forumParam.getActionType()) {
            this.redisStringAdapter.remove(readRecordKey);
            this.redisStringAdapter.remove(lastRecommendedKey);
            recommendList = this.getRecommendPost(forumParam, readRecordList, shieldUserList, readRecordKey, forumParam.getPlatform());
        } else {
            readRecordList.addAll(this.redisSetAdapter.getAllMembers(readRecordKey, Long.class));
            lastRecommendedTime = this.redisStringAdapter.getString(lastRecommendedKey);
        }
        int leftNum = forumParam.getPageSize() - recommendList.size();
        if (leftNum > 0) {
            this.getData(forumParam, result, readRecordKey, lastRecommendedKey, readRecordList, shieldUserList, lastRecommendedTime, leftNum, 3);
        }
        this.interspersedRecommendPost(recommendList, result);
        return result;
    }

    private void getData(ForumParam forumParam, LinkedList<Long> result, KeyGenerator readRecordKey, KeyGenerator lastRecommendedKey, Set<Long> readRecordList, Set<Long> shieldUserList, String lastRecommendedTime, int leftNum, int maxRetry) {
        if (maxRetry <= 0) {
            return;
        }
        ForumQueryParam param = this.getQueryParam(forumParam, lastRecommendedTime);
        List forumPostList = null;
        forumPostList = org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)param.getTopicIds()) ? this.forumPostMapper.findForumPostListByTopicIds(param) : this.forumPostMapper.findForumPostList(param);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)forumPostList)) {
            return;
        }
        Date newLastRecommendedTime = this.recommendedFilter((List<ForumRecommend>)forumPostList, result, readRecordKey, lastRecommendedKey, readRecordList, shieldUserList, leftNum);
        if (result.size() < leftNum && null != newLastRecommendedTime) {
            lastRecommendedTime = DateUtils.formatDateTime((Date)newLastRecommendedTime);
            this.getData(forumParam, result, readRecordKey, lastRecommendedKey, readRecordList, shieldUserList, lastRecommendedTime, leftNum, --maxRetry);
        }
    }

    private void interspersedRecommendPost(LinkedList<Long> recommendPostIds, List<Long> postIds) {
        if (!CollectionUtils.isEmpty(recommendPostIds)) {
            int count = recommendPostIds.size();
            int index = 0;
            for (int i = 0; i < count; ++i) {
                if (index >= postIds.size()) {
                    recommendPostIds.addLast(recommendPostIds.get(i));
                    continue;
                }
                postIds.add(index, recommendPostIds.get(i));
                index += 2;
            }
        }
    }

    private LinkedList<Long> getRecommendPost(ForumParam forumParam, Set<Long> readRecordList, Set<Long> shieldUserList, KeyGenerator readRecordKey, int platform) {
        LinkedList<Long> result = new LinkedList<Long>();
        if (forumParam.getOperationId().intValue() == OperationLocationEnum.FORUM_HOME_PAGE.getCode()) {
            HashSet homeRecordList = Sets.newHashSet(readRecordList);
            KeyGenerator dailyRecommendKey = RedisKeyConstant.FORUM_RECOMMENDED.copy().appendKey((Object)forumParam.getUserId()).appendKey((Object)platform).appendKey((Object)OperationLocationEnum.getName((int)forumParam.getOperationId())).appendKey((Object)DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd"));
            if (!this.redisStringAdapter.hasKey(dailyRecommendKey).booleanValue()) {
                KeyGenerator homeReadRecordKey = RedisKeyConstant.FORUM_RECOMMENDED.copy().appendKey((Object)forumParam.getUserId()).appendKey((Object)platform).appendKey((Object)OperationLocationEnum.HOME_PAGE.getName()).appendKey((Object)"already");
                homeRecordList.addAll(this.redisSetAdapter.getAllMembers(homeReadRecordKey, Long.class));
                List forumPostIdList = this.forumPostMapper.findRecommendForumPost(forumParam.getAreaCode(), 100);
                this.recommendedFilter((List<ForumRecommend>)forumPostIdList, result, homeReadRecordKey, readRecordKey, (Set<Long>)homeRecordList, shieldUserList, readRecordList);
                this.redisStringAdapter.set(dailyRecommendKey, (Object)1, (long)DateUtils.getCurSeconds());
            }
        }
        return result;
    }

    private ForumQueryParam getQueryParam(ForumParam forumParam, String lastRecommendedTime) {
        Integer isBrilliant = OperationLocationEnum.FORUM_PLATE_ELITE.getCode() == forumParam.getOperationId().intValue() ? Integer.valueOf(1) : null;
        ForumQueryParam param = new ForumQueryParam();
        param.setAreaCode(forumParam.getAreaCode());
        param.setBrilliant(isBrilliant);
        param.setUserId(forumParam.getUserId());
        param.setForumId(forumParam.getForumId());
        param.setLastTime(lastRecommendedTime);
        if (StringUtils.isEmpty((String)forumParam.getChannelIds())) {
            param.setTopicId(forumParam.getTopicId());
        } else {
            List<Object> idsString = new ArrayList();
            idsString = Arrays.asList(forumParam.getChannelIds().split(","));
            param.setTopicIds(idsString.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList()));
        }
        param.setSize(Integer.valueOf(forumParam.getPageSize() + 50));
        if (forumParam.getOperationId().intValue() == OperationLocationEnum.FORUM_HOME_PAGE.getCode()) {
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)this.recommendProperties.getFilterForumId())) {
                param.setFilterForumId(this.recommendProperties.getFilterForumId());
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)this.recommendProperties.getFilterTopicId())) {
                param.setFilterTopicId(this.recommendProperties.getFilterTopicId());
            }
        }
        return param;
    }

    private void recommendedFilter(List<ForumRecommend> originList, List<Long> resultList, KeyGenerator homeReadRecordKey, KeyGenerator readRecordKey, Set<Long> homeReadRecordList, Set<Long> shieldUserList, Set<Long> readRecordList) {
        for (ForumRecommend forumRecommend : originList) {
            if (!homeReadRecordList.contains(forumRecommend.getId()) && !shieldUserList.contains(forumRecommend.getUserId())) {
                homeReadRecordList.add(forumRecommend.getId());
                resultList.add(forumRecommend.getId());
                readRecordList.add(forumRecommend.getId());
            }
            if (resultList.size() < 3) continue;
            break;
        }
        logger.debug("[recommendedFilter]\u5df2\u53d6\u5f97{}\u6761\u4f18\u8d28\u5e16\u5b50\u63a8\u8350\u6570\u636e\uff0c\u529f\u6210\u5706\u6ee1", (Object)resultList.size());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(resultList)) {
            this.redisSetAdapter.add(homeReadRecordKey, resultList.toArray());
            this.redisSetAdapter.expire(homeReadRecordKey, (long)NewsCacheThresholdConfig.MIX_EXPIRE_RECOMMENDED_RECORD);
            this.redisSetAdapter.add(readRecordKey, resultList.toArray());
            this.redisSetAdapter.expire(readRecordKey, (long)NewsCacheThresholdConfig.MIX_EXPIRE_RECOMMENDED_RECORD);
        }
    }

    private Date recommendedFilter(List<ForumRecommend> originList, LinkedList<Long> resultList, KeyGenerator recommendRecordKey, KeyGenerator lastRecommendedKey, Set<Long> readRecordList, Set<Long> shieldUserList, int num) {
        Date lastReadTime = null;
        for (ForumRecommend forumRecommend : originList) {
            if (!readRecordList.contains(forumRecommend.getId()) && !shieldUserList.contains(forumRecommend.getUserId())) {
                resultList.add(forumRecommend.getId());
                readRecordList.add(forumRecommend.getId());
                lastReadTime = forumRecommend.getDisplayTime();
            }
            if (resultList.size() < num) continue;
            break;
        }
        logger.debug("[recommendedFilter]\u5df2\u53d6\u5f97{}\u6761\u5e16\u5b50\u63a8\u8350\u6570\u636e\uff0c\u529f\u6210\u5706\u6ee1", (Object)resultList.size());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(resultList)) {
            this.redisSetAdapter.add(recommendRecordKey, resultList.toArray());
            this.redisSetAdapter.expire(recommendRecordKey, (long)NewsCacheThresholdConfig.MIX_EXPIRE_RECOMMENDED_RECORD);
            if (Objects.nonNull(lastReadTime)) {
                this.redisStringAdapter.set(lastRecommendedKey, (Object)DateUtils.formatDateTime((Date)lastReadTime));
                this.redisStringAdapter.expire(lastRecommendedKey, (long)NewsCacheThresholdConfig.MIX_EXPIRE_RECOMMENDED_RECORD);
            }
        } else {
            lastReadTime = originList.get(originList.size() - 1).getDisplayTime();
        }
        return lastReadTime;
    }
}

