/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.recommend.handler.forum;

import com.alibaba.fastjson.JSONObject;
import com.bxm.newidea.domain.ForumPostMapper;
import com.bxm.newidea.domain.LocalnewsRecommendedMapper;
import com.bxm.newidea.domain.MixedRecommendPoolMapper;
import com.bxm.newidea.dto.MixRecomendResult;
import com.bxm.newidea.param.ForumParam;
import com.bxm.newidea.properties.RecommendProperties;
import com.bxm.newidea.recommend.framework.AbstractForumRecommender;
import com.bxm.newidea.vo.ForumPost;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ForumDetailRecommender
extends AbstractForumRecommender {
    private static final Logger LOG = LoggerFactory.getLogger(ForumDetailRecommender.class);
    @Autowired
    private ForumPostMapper forumPostMapper;
    @Autowired
    private LocalnewsRecommendedMapper localNewsMapper;
    @Autowired
    private RecommendProperties recommendProperties;
    @Autowired
    private MixedRecommendPoolMapper mixedRecommendPoolMapper;

    public ForumDetailRecommender() {
        super(1.0, 1);
    }

    @Override
    public List<Long> syncRecommend(ForumParam forumParam) {
        HashSet result = Sets.newHashSet();
        if (null == forumParam.getPostId()) {
            LOG.warn("[forum detail] post_id is null");
            return Lists.newArrayList((Iterable)result);
        }
        Long province = Long.valueOf(forumParam.getAreaCode().substring(0, 2));
        int newsNum = 2;
        List newsList = this.localNewsMapper.findNewsByForumTag(forumParam.getAreaCode(), forumParam.getPostId(), province, forumParam.getUserId(), Integer.valueOf(newsNum));
        this.logger.debug("tag\u6807\u7b7e\u5339\u914d\u65b0\u95fb\u6570\u91cf:{}", (Object)JSONObject.toJSONString((Object)newsList));
        result.addAll(newsList);
        int postNum = 3;
        List<Long> postIds = this.getPostId(forumParam, postNum);
        result.addAll(postIds);
        if (forumParam.getPlatform() == 3) {
            return this.getResultToH5(result, forumParam.getAreaCode(), forumParam.getPostId());
        }
        return this.getResultToClient(result, newsNum + postNum, forumParam.getAreaCode(), forumParam.getPostId());
    }

    public List<Long> getResultToClient(Set<Long> result, int size, String areaCode, Long id) {
        HashSet removeId = Sets.newHashSet((Object[])new Long[]{id});
        if (result.size() < size) {
            List list = this.mixedRecommendPoolMapper.selectLastRecommendList(null, areaCode, Integer.valueOf(30), (Set)removeId);
            this.logger.debug("\u63a8\u8350\u5e93\u83b7\u5f97\u6570\u91cf:{}", (Object)JSONObject.toJSONString((Object)list));
            while (CollectionUtils.isNotEmpty((Collection)list)) {
                int i = RandomUtils.nextInt((int)0, (int)(list.size() - 1));
                MixRecomendResult recomendResult = (MixRecomendResult)list.get(i);
                result.add(recomendResult.getId());
                list.remove(recomendResult);
                if (result.size() < size) continue;
                break;
            }
        }
        return Lists.newArrayList(result);
    }

    public List<Long> getResultToH5(Set<Long> result, String areaCode, Long id) {
        LinkedList objects = Lists.newLinkedList();
        Set<Long> mixResult = this.getMixRecommand(result, areaCode, 10 - result.size(), id);
        this.logger.debug("\u63a8\u8350\u5e93\u63a8\u8350\u6570\u636e[{}]", (Object)JSONObject.toJSONString(mixResult));
        for (int i = 0; i < 10; ++i) {
            if (i % 2 == 0 || result.isEmpty()) {
                Optional mix = mixResult.stream().findFirst();
                if (!mix.isPresent()) continue;
                objects.add(mix.get());
                mixResult.remove(mix.get());
                continue;
            }
            Optional newAndPost = result.stream().findFirst();
            objects.add(newAndPost.get());
            result.remove(newAndPost.get());
        }
        return objects;
    }

    private Set<Long> getMixRecommand(Set<Long> result, String areaCode, int mixNum, Long id) {
        int pageSize = 30;
        HashSet mixResult = Sets.newHashSet();
        HashSet removeId = Sets.newHashSet((Object[])new Long[]{id});
        List list = this.mixedRecommendPoolMapper.selectLastRecommendList(null, areaCode, Integer.valueOf(30), (Set)removeId);
        while (CollectionUtils.isNotEmpty((Collection)list)) {
            int i = RandomUtils.nextInt((int)0, (int)(list.size() - 1));
            MixRecomendResult recomendResult = (MixRecomendResult)list.get(i);
            if (!result.contains(recomendResult.getId())) {
                mixResult.add(recomendResult.getId());
            }
            list.remove(recomendResult);
            if (mixResult.size() < mixNum) continue;
            break;
        }
        return mixResult;
    }

    private List<Long> getPostId(ForumParam forumParam, int postNum) {
        ArrayList result = Lists.newArrayList();
        List filterForumId = this.recommendProperties.getFilterForumId();
        int enoughPostNum = 100;
        List forumList = this.forumPostMapper.findForumPostByTag(forumParam.getPostId(), enoughPostNum, forumParam.getAreaCode(), filterForumId);
        Map<Long, List<ForumPost>> collect = forumList.stream().collect(Collectors.groupingBy(ForumPost::getUserId));
        Set<Long> userIds = collect.keySet();
        for (Long userid : userIds) {
            List<ForumPost> forumPosts = collect.get(userid);
            Optional first = forumPosts.stream().findFirst();
            if (first.isPresent()) {
                result.add(((ForumPost)first.get()).getId());
            }
            if (result.size() < postNum) continue;
            break;
        }
        this.logger.debug("tag\u6807\u7b7e\u5339\u914d\u5e16\u5b50\u6570\u91cf:{}", (Object)JSONObject.toJSONString((Object)result));
        return result;
    }
}

