/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.recommend.handler.forum;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.constant.RedisKeyConstant;
import com.bxm.newidea.domain.ForumPostMapper;
import com.bxm.newidea.enums.OperationLocationEnum;
import com.bxm.newidea.param.ForumParam;
import com.bxm.newidea.param.ForumQueryParam;
import com.bxm.newidea.recommend.framework.AbstractForumRecommender;
import com.bxm.newidea.util.ObjectUtil;
import com.bxm.newidea.vo.ForumRecommend;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ForumTopicHotRecommender
extends AbstractForumRecommender {
    private static final Logger LOG = LoggerFactory.getLogger(ForumTopicHotRecommender.class);
    @Autowired
    private RedisSetAdapter redisSetAdapter;
    @Autowired
    private RedisStringAdapter redisStringAdapter;
    @Autowired
    private ForumPostMapper forumPostMapper;

    public ForumTopicHotRecommender() {
        super(1.0, 1);
    }

    @Override
    public List<Long> syncRecommend(ForumParam forumParam) {
        Integer operationId = forumParam.getOperationId();
        KeyGenerator recommendedKey = RedisKeyConstant.FORUM_RECOMMENDED.copy().appendKey((Object)forumParam.getUserId()).appendKey((Object)forumParam.getPlatform()).appendKey((Object)OperationLocationEnum.getName((int)operationId)).appendKey((Object)"already");
        KeyGenerator lastRecommendedKey = RedisKeyConstant.FORUM_RECOMMENDED.copy().appendKey((Object)forumParam.getUserId()).appendKey((Object)forumParam.getPlatform()).appendKey((Object)OperationLocationEnum.getName((int)operationId)).appendKey((Object)"last");
        KeyGenerator shieldRecordKey = RedisKeyConstant.NEWS_SHIELD.copy().appendKey((Object)"detail").appendKey((Object)forumParam.getUserId());
        KeyGenerator shieldUserKey = RedisKeyConstant.NEWS_SHIELD.copy().appendKey((Object)"user").appendKey((Object)forumParam.getUserId());
        HashSet readRecordList = Sets.newHashSet();
        Integer lastHotScore = 0;
        if (null == forumParam.getActionType() || 1 == forumParam.getActionType()) {
            this.redisStringAdapter.remove(recommendedKey);
            this.redisStringAdapter.remove(lastRecommendedKey);
        } else {
            readRecordList.addAll(this.redisSetAdapter.getAllMembers(recommendedKey, Long.class));
            lastHotScore = this.redisStringAdapter.getInt(lastRecommendedKey);
        }
        readRecordList.addAll(this.redisSetAdapter.getAllMembers(shieldRecordKey, Long.class));
        Set shieldUserList = this.redisSetAdapter.getAllMembers(shieldUserKey, Long.class);
        ForumQueryParam param = this.getQueryParam(forumParam, lastHotScore);
        List forumPostList = null;
        forumPostList = CollectionUtils.isNotEmpty((Collection)param.getTopicIds()) ? this.forumPostMapper.findForumPostListByTopicIds(param) : this.forumPostMapper.findForumPostList(param);
        ArrayList result = Lists.newArrayList();
        lastHotScore = this.findMoreForumPost(result, forumPostList, readRecordList, shieldUserList, param, 0);
        if (null != lastHotScore) {
            this.redisStringAdapter.set(lastRecommendedKey, (Object)lastHotScore);
        }
        if (result.size() != 0) {
            this.redisSetAdapter.add(recommendedKey, (Object[])result.toArray(new Long[0]));
        }
        return result;
    }

    private Integer findMoreForumPost(List<Long> result, List<ForumRecommend> forumPostList, Set<Long> readRecordList, Set<Long> shieldUserList, ForumQueryParam param, int count) {
        if (null == forumPostList || forumPostList.size() == 0 || 2 == count) {
            LOG.warn("[forum topic hot]post is none");
            return null;
        }
        int postSize = forumPostList.size();
        Integer lastHotScore = param.getHotScore();
        boolean hasMore = true;
        for (int j = 0; j < postSize; ++j) {
            Long id = ObjectUtil.displayToLong(forumPostList.get(j).getId());
            if (null != id && !readRecordList.contains(id) && !shieldUserList.contains(forumPostList.get(j).getUserId())) {
                if (!result.contains(id)) {
                    result.add(id);
                    readRecordList.add(id);
                } else if (j == postSize - 1) {
                    hasMore = false;
                }
                if (result.size() >= param.getSize()) {
                    return ((ForumRecommend)forumPostList.get(j)).getHotScore();
                }
            }
            lastHotScore = j == postSize - 1 && !hasMore ? null : forumPostList.get(j).getHotScore();
        }
        if (result.size() < param.getSize()) {
            if (null == lastHotScore) {
                return param.getHotScore();
            }
            param.setHotScore(lastHotScore);
            this.logger.info("ForumTopicHotRecommender-----" + CollectionUtils.isNotEmpty((Collection)param.getTopicIds()));
            forumPostList = CollectionUtils.isNotEmpty((Collection)param.getTopicIds()) ? this.forumPostMapper.findForumPostListByTopicIds(param) : this.forumPostMapper.findForumPostList(param);
            return this.findMoreForumPost(result, forumPostList, readRecordList, shieldUserList, param, ++count);
        }
        return lastHotScore;
    }

    private ForumQueryParam getQueryParam(ForumParam forumParam, Integer lastRecommendedTime) {
        ForumQueryParam param = new ForumQueryParam();
        param.setAreaCode(forumParam.getAreaCode());
        param.setSize(forumParam.getPageSize());
        if (StringUtils.isEmpty((CharSequence)forumParam.getChannelIds())) {
            param.setTopicId(forumParam.getTopicId());
        } else {
            List<Object> idsString = new ArrayList();
            idsString = Arrays.asList(forumParam.getChannelIds().split(","));
            param.setTopicIds(idsString.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList()));
        }
        param.setHot(Integer.valueOf(0));
        param.setUserId(forumParam.getUserId());
        param.setHotScore(lastRecommendedTime);
        return param;
    }
}

