/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.recommend.handler.forum;

import com.alibaba.fastjson.JSON;
import com.bxm.newidea.domain.ForumPostMapper;
import com.bxm.newidea.param.ForumParam;
import com.bxm.newidea.recommend.framework.AbstractForumRecommender;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NoteDetailRecommender
extends AbstractForumRecommender {
    private static final Logger log = LoggerFactory.getLogger(NoteDetailRecommender.class);
    @Autowired
    private ForumPostMapper forumPostMapper;

    public NoteDetailRecommender() {
        super(1.0, 1);
    }

    @Override
    public List<Long> syncRecommend(ForumParam forumParam) {
        List otherNoteList;
        ArrayList<Long> result = new ArrayList<Long>();
        if (null == forumParam.getPostId()) {
            log.warn("[note detail] post_id is null");
            return result;
        }
        if (null == forumParam.getPostUserId()) {
            log.warn("[note detail] post_user_id is null");
            return result;
        }
        List sameUserNoteList = this.forumPostMapper.findSameUserNoteList(forumParam.getPostId(), forumParam.getPostUserId(), forumParam.getPostNum().intValue());
        int size = 0;
        if (CollectionUtils.isNotEmpty((Collection)sameUserNoteList)) {
            size = sameUserNoteList.size();
            result.addAll(sameUserNoteList);
        }
        if (size < forumParam.getPostNum() && CollectionUtils.isNotEmpty((Collection)(otherNoteList = this.forumPostMapper.findOtherUserNoteList(forumParam.getPostId(), forumParam.getPostUserId(), forumParam.getAreaCode(), forumParam.getPostNum() - size)))) {
            result.addAll(otherNoteList);
        }
        log.debug("\u5c0f\u7eb8\u6761\u63a8\u8350\u7ed3\u679c\uff1a" + JSON.toJSONString(result));
        return result;
    }
}

