/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.recommend.handler.forum;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.config.NewsCacheThresholdConfig;
import com.bxm.newidea.constant.RedisKeyConstant;
import com.bxm.newidea.domain.ForumPostMapper;
import com.bxm.newidea.enums.OperationLocationEnum;
import com.bxm.newidea.param.ForumParam;
import com.bxm.newidea.recommend.framework.AbstractForumRecommender;
import com.bxm.newidea.vo.ForumTopPost;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Deprecated
public class RecentlyForumHomePageRecommender
extends AbstractForumRecommender {
    @Autowired
    private RedisSetAdapter redisSetAdapter;
    @Autowired
    private RedisStringAdapter redisStringAdapter;
    @Autowired
    private RedisListAdapter redisListAdapter;
    @Autowired
    private ForumPostMapper forumPostMapper;

    public RecentlyForumHomePageRecommender() {
        super(1.0, 1);
    }

    @Override
    public List<Long> syncRecommend(ForumParam forumParam) {
        Date lastReadTime;
        List forumTopPostList;
        long begin = System.currentTimeMillis();
        Long userId = forumParam.getUserId();
        Integer operationId = forumParam.getOperationId();
        KeyGenerator recommendedKey = RedisKeyConstant.FORUM_RECOMMENDED.copy().appendKey((Object)userId).appendKey((Object)OperationLocationEnum.getName((int)operationId)).appendKey((Object)"browsingKey");
        KeyGenerator lastRecommendedKey = RedisKeyConstant.FORUM_RECOMMENDED.copy().appendKey((Object)userId).appendKey((Object)OperationLocationEnum.getName((int)operationId)).appendKey((Object)"lastreadtime");
        KeyGenerator postUserTopKey = RedisKeyConstant.FORUM_RECOMMENDED.copy().appendKey((Object)userId).appendKey((Object)"top");
        KeyGenerator forumPostPoolKey = RedisKeyConstant.FORUM_RECOMMENDED.copy().appendKey((Object)userId).appendKey((Object)OperationLocationEnum.getName((int)operationId)).appendKey((Object)"recentlypool");
        if (2 == forumParam.getActionType()) {
            return new ArrayList<Long>();
        }
        this.redisSetAdapter.remove(recommendedKey);
        ArrayList<Long> resultList = new ArrayList<Long>();
        Long postUserTopSize = this.redisListAdapter.size(postUserTopKey);
        if (postUserTopSize > 0L && CollectionUtils.isNotEmpty(forumTopPostList = this.redisListAdapter.leftIndex(postUserTopKey, postUserTopSize - 1L, ForumTopPost.class).stream().filter(e -> e.getAreaCode().equals(forumParam.getAreaCode())).sorted(Comparator.comparing(ForumTopPost::getDisplayTime).reversed()).collect(Collectors.toList()))) {
            List ids = forumTopPostList.stream().map(ForumTopPost::getId).collect(Collectors.toList());
            forumParam.setPageSize(Integer.valueOf(forumParam.getPageSize() - forumTopPostList.size()));
            resultList.addAll(ids);
            this.redisSetAdapter.add(recommendedKey, (Object[])resultList.toArray(new Long[0]));
            this.redisSetAdapter.expire(recommendedKey, (long)NewsCacheThresholdConfig.MIX_EXPIRE_RECOMMENDED_RECORD);
        }
        if (null == (lastReadTime = (Date)this.redisStringAdapter.get(lastRecommendedKey, Date.class))) {
            return resultList;
        }
        long size = this.fillMixRecentlyPool(forumPostPoolKey, lastReadTime, forumParam.getAreaCode());
        if (size == 0L) {
            return resultList;
        }
        this.recommendedFilter(forumPostPoolKey, recommendedKey, forumParam.getPageSize(), resultList);
        if (CollectionUtils.isNotEmpty(resultList)) {
            this.redisStringAdapter.set(lastRecommendedKey, (Object)new Date(), (long)NewsCacheThresholdConfig.MIX_EXPIRE_LAST_READ_TIME);
        }
        this.logger.debug("\u540c\u6b65\u63a8\u8350\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - begin));
        return resultList;
    }

    private long fillMixRecentlyPool(KeyGenerator mixRecentlyPoolKey, Date lastReadTime, String areaCode) {
        List mixRecommendResultList;
        long size = this.redisListAdapter.size(mixRecentlyPoolKey);
        if (size == 0L && (size = (long)(mixRecommendResultList = this.forumPostMapper.selectRecentlyPostList(lastReadTime, areaCode)).size()) != 0L) {
            this.redisListAdapter.rightPush(mixRecentlyPoolKey, (Object[])mixRecommendResultList.toArray(new Long[0]));
            this.redisListAdapter.expire(mixRecentlyPoolKey, (long)NewsCacheThresholdConfig.MIX_EXPIRE_RECENTLY_POOL);
        }
        return size;
    }

    protected void recommendedFilter(KeyGenerator mixRecentlyPoolKey, KeyGenerator mixRecordKey, Integer num, List<Long> resultList) {
        Long mixRecentlyPoolResult;
        long begin = System.currentTimeMillis();
        long total = this.redisListAdapter.size(mixRecentlyPoolKey);
        this.logger.debug("[recentlyRecommendedFilter]redis\u62c9\u53d6\u5217\u8868\u8017\u65f6\uff1a{} \u5217\u8868\u957f\uff1a{}", (Object)(System.currentTimeMillis() - begin), (Object)total);
        if (total == 0L) {
            return;
        }
        List mixRecomendResultList = this.redisListAdapter.leftIndex(mixRecentlyPoolKey, total, Long.class);
        int i = 0;
        Iterator iterator = mixRecomendResultList.iterator();
        while (iterator.hasNext() && (mixRecentlyPoolResult = (Long)iterator.next()) != null) {
            this.generateResult(mixRecordKey, mixRecentlyPoolResult, resultList);
            ++i;
            if (resultList.size() < num) continue;
            this.logger.info("[recentlyRecommendedFilter]\u5df2\u53d6\u5f97{}\u6761\u6700\u65b0\u6df7\u5408\u63a8\u8350\u6570\u636e\uff0c\u529f\u6210\u5706\u6ee1", (Object)num);
            break;
        }
        this.redisListAdapter.leftTrim(mixRecentlyPoolKey, (long)i, total);
        this.redisSetAdapter.add(mixRecordKey, (Object[])resultList.toArray(new Long[0]));
        this.redisSetAdapter.expire(mixRecordKey, (long)NewsCacheThresholdConfig.MIX_EXPIRE_RECOMMENDED_RECORD);
        this.logger.info("[recentlyRecommendedFilter]bloom\u53bb\u91cd\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - begin));
    }

    private void generateResult(KeyGenerator mixRecordKey, Long id, List<Long> resultList) {
        Set record = this.redisSetAdapter.getAllMembers(mixRecordKey, Long.class);
        if (!record.contains(id)) {
            resultList.add(id);
            record.add(id);
        }
    }
}

