/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.recommend.handler.mix;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.config.NewsCacheThresholdConfig;
import com.bxm.newidea.constant.RedisKeyConstant;
import com.bxm.newidea.domain.MixedRecommendPoolMapper;
import com.bxm.newidea.dto.MixRecomendResult;
import com.bxm.newidea.enums.OperationLocationEnum;
import com.bxm.newidea.recommend.framework.AbstractMixRecommender;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommonMixRecommender
extends AbstractMixRecommender {
    @Autowired(required=false)
    public CommonMixRecommender(RedisSetAdapter redisSetAdapter, RedisListAdapter redisListAdapter, RedisStringAdapter redisStringAdapter, MixedRecommendPoolMapper mixedRecommendPoolMapper) {
        super(1.0, 1);
        this.redisSetAdapter = redisSetAdapter;
        this.redisListAdapter = redisListAdapter;
        this.redisStringAdapter = redisStringAdapter;
        this.mixedRecommendPoolMapper = mixedRecommendPoolMapper;
    }

    @Override
    protected List<MixRecomendResult> syncRecommend(Long userId, Integer actionType, Integer num, String areaCode, int platform) {
        KeyGenerator recommendedKey = RedisKeyConstant.FORUM_RECOMMENDED.copy().appendKey((Object)userId).appendKey((Object)platform).appendKey((Object)OperationLocationEnum.HOME_PAGE.getName()).appendKey((Object)"already");
        KeyGenerator lastRecommendedKey = RedisKeyConstant.FORUM_RECOMMENDED.copy().appendKey((Object)userId).appendKey((Object)platform).appendKey((Object)OperationLocationEnum.HOME_PAGE.getName()).appendKey((Object)"last");
        KeyGenerator shieldRecordKey = RedisKeyConstant.NEWS_SHIELD.copy().appendKey((Object)"detail").appendKey((Object)userId);
        KeyGenerator shieldUserKey = RedisKeyConstant.NEWS_SHIELD.copy().appendKey((Object)"user").appendKey((Object)userId);
        ArrayList result = Lists.newArrayList();
        Set<Long> readRecordList = Sets.newHashSet();
        Integer lastWeight = null;
        if (1 == actionType) {
            this.redisStringAdapter.remove(recommendedKey);
            this.redisStringAdapter.remove(lastRecommendedKey);
        } else {
            readRecordList = this.redisSetAdapter.getAllMembers(recommendedKey, Long.class);
            lastWeight = this.redisStringAdapter.getInt(lastRecommendedKey);
        }
        readRecordList.addAll(this.redisSetAdapter.getAllMembers(shieldRecordKey, Long.class));
        Set shieldUserList = this.redisSetAdapter.getAllMembers(shieldUserKey, Long.class);
        this.getData(num, areaCode, recommendedKey, lastRecommendedKey, result, readRecordList, lastWeight, shieldUserList);
        return result;
    }

    private void getData(Integer num, String areaCode, KeyGenerator recommendedKey, KeyGenerator lastRecommendedKey, List<MixRecomendResult> result, Set<Long> readRecordList, Integer lastWeight, Set<Long> shieldUserList) {
        List originList = this.mixedRecommendPoolMapper.selectLastRecommendList(lastWeight, areaCode, Integer.valueOf(100), readRecordList);
        lastWeight = this.recommendedFilter(originList, result, recommendedKey, lastRecommendedKey, readRecordList, shieldUserList, num);
        if (result.size() < num && null != lastWeight) {
            this.getData(num, areaCode, recommendedKey, lastRecommendedKey, result, readRecordList, lastWeight, shieldUserList);
        }
    }

    private Integer recommendedFilter(List<MixRecomendResult> originList, List<MixRecomendResult> resultList, KeyGenerator recommendedKey, KeyGenerator lastRecommendedKey, Set<Long> readRecordList, Set<Long> shieldUserList, int num) {
        Integer weight = null;
        for (MixRecomendResult mixRecomendResult : originList) {
            this.generateResult(readRecordList, shieldUserList, mixRecomendResult, resultList);
            weight = mixRecomendResult.getWeight();
            if (resultList.size() < num) continue;
            this.logger.info("[recommendedFilter]\u5df2\u53d6\u5f97{}\u6761\u6df7\u5408\u63a8\u8350\u6570\u636e\uff0c\u529f\u6210\u5706\u6ee1", (Object)num);
            break;
        }
        if (CollectionUtils.isNotEmpty(resultList)) {
            this.redisSetAdapter.add(recommendedKey, (Object[])resultList.stream().map(MixRecomendResult::getId).toArray(Long[]::new));
            this.redisSetAdapter.expire(recommendedKey, (long)NewsCacheThresholdConfig.MIX_EXPIRE_RECOMMENDED_RECORD);
            this.redisStringAdapter.set(lastRecommendedKey, (Object)resultList.get(resultList.size() - 1).getWeight());
            this.redisStringAdapter.expire(lastRecommendedKey, (long)NewsCacheThresholdConfig.MIX_EXPIRE_RECOMMENDED_RECORD);
        }
        return weight;
    }

    private void generateResult(Set<Long> readRecordList, Set<Long> shieldUserList, MixRecomendResult mixRecommendResult, List<MixRecomendResult> resultList) {
        if (!readRecordList.contains(mixRecommendResult.getId()) && !shieldUserList.contains(mixRecommendResult.getUserId())) {
            MixRecomendResult mixRecommendResultCopy = new MixRecomendResult(mixRecommendResult.getId(), mixRecommendResult.getOrigin(), mixRecommendResult.getWeight(), mixRecommendResult.getUserId());
            resultList.add(mixRecommendResultCopy);
            readRecordList.add(mixRecommendResultCopy.getId());
        }
    }
}

