/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.recommend.handler.mix;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.config.NewsCacheThresholdConfig;
import com.bxm.newidea.constant.RedisKeyConstant;
import com.bxm.newidea.domain.MixedRecommendPoolMapper;
import com.bxm.newidea.dto.MixRecomendResult;
import com.bxm.newidea.recommend.framework.AbstractMixRecommender;
import com.bxm.newidea.service.MixRecommendService;
import com.bxm.newidea.vo.CircleNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Deprecated
public class FixMixRecommender
extends AbstractMixRecommender {
    private MixRecommendService mixRecommendService;

    @Autowired(required=false)
    public FixMixRecommender(RedisSetAdapter redisSetAdapter, RedisListAdapter redisListAdapter, RedisStringAdapter redisStringAdapter, MixedRecommendPoolMapper mixedRecommendPoolMapper, MixRecommendService mixRecommendService) {
        super(1.0, 2);
        this.redisSetAdapter = redisSetAdapter;
        this.redisListAdapter = redisListAdapter;
        this.redisStringAdapter = redisStringAdapter;
        this.mixedRecommendPoolMapper = mixedRecommendPoolMapper;
        this.mixRecommendService = mixRecommendService;
    }

    @Override
    protected List<MixRecomendResult> syncRecommend(Long userId, Integer actionType, Integer num, String areaCode, int platform) {
        long begin = System.currentTimeMillis();
        KeyGenerator mixRecordKey = RedisKeyConstant.MIX_RECOMMENDED.copy().appendKey((Object)userId);
        KeyGenerator indexKey = RedisKeyConstant.MIX_FIX_INDEX.copy().appendKey((Object)userId);
        KeyGenerator userCacheKey = RedisKeyConstant.MIX_LAST_READ_TIME.copy().appendKey((Object)userId);
        ArrayList<MixRecomendResult> resultList = new ArrayList<MixRecomendResult>();
        int index = this.getInitIndex(userId, indexKey, userCacheKey);
        this.logger.info("[syncRecommend]\u56fa\u5b9a\u63a8\u8350\u6c60\u6e38\u6807\uff1a{}", (Object)index);
        CircleNode[] mixRecommendResultArray = this.getData(areaCode);
        this.logger.info("[syncRecommendPost]\u56fa\u5b9a\u63a8\u8350\u5e93\u5bb9\u91cf\uff1a{}", (Object)(mixRecommendResultArray != null ? mixRecommendResultArray.length : 0));
        if (mixRecommendResultArray == null || mixRecommendResultArray.length == 0) {
            return resultList;
        }
        this.recommendedFilter(mixRecommendResultArray, mixRecordKey, indexKey, index, num, actionType, resultList, userId, platform);
        this.logger.debug("\u540c\u6b65\u63a8\u8350\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - begin));
        return resultList;
    }

    private CircleNode[] getData(String areaCode) {
        List mixRecommendResultList;
        CircleNode[] mixRecommendResultArray = (CircleNode[])mixRecommendResults.get(areaCode);
        if ((mixRecommendResultArray == null || mixRecommendResultArray.length == 0) && CollectionUtils.isNotEmpty((Collection)(mixRecommendResultList = this.mixedRecommendPoolMapper.selectFixRecommendList(Integer.valueOf(5000), areaCode)))) {
            mixRecommendResultArray = this.mixRecommendService.getCircleNode(mixRecommendResultList);
            mixRecommendResults.put(areaCode, mixRecommendResultArray);
        }
        return mixRecommendResultArray;
    }

    private int getInitIndex(Long userId, KeyGenerator indexCacheKey, KeyGenerator userCacheKey) {
        int index = this.redisStringAdapter.getString(userCacheKey).isEmpty() ? 0 : this.redisStringAdapter.getInt(indexCacheKey);
        return index;
    }

    private void doDownRefresh(CircleNode[] circleNodes, List<MixRecomendResult> resultList, KeyGenerator mixRecordKey, KeyGenerator indexKey, Integer fromIndex, Integer num, Long userId, int platform) {
        int total = circleNodes.length;
        if (fromIndex >= total) {
            fromIndex = 0;
            this.mixRecommendService.cleanMixCache(userId, platform);
        }
        int next = fromIndex;
        Set record = this.redisSetAdapter.getAllMembers(mixRecordKey, Long.class);
        for (int i = 0; i < total; ++i) {
            CircleNode circleNode = circleNodes[next];
            this.generateResult(record, mixRecordKey, circleNode, resultList);
            next = circleNode.getNext();
            if (resultList.size() < num) continue;
            this.logger.info("[doDownRefresh]\u5df2\u53d6\u5f97{}\u6761\u6df7\u5408\u63a8\u8350\u6570\u636e\uff0c\u529f\u6210\u5706\u6ee1,\u6e38\u6807\uff1a{}", (Object)num, (Object)next);
            break;
        }
        if (CollectionUtils.isNotEmpty(resultList)) {
            this.redisSetAdapter.add(mixRecordKey, (Object[])resultList.stream().map(MixRecomendResult::getId).toArray(Long[]::new));
            this.redisSetAdapter.expire(mixRecordKey, (long)NewsCacheThresholdConfig.MIX_EXPIRE_RECOMMENDED_RECORD);
            this.redisStringAdapter.set(indexKey, (Object)next, (long)NewsCacheThresholdConfig.MIX_EXPIRE_FIX_INDEX);
        }
        this.logger.info("[doDownRefresh]\u7ed3\u675f\u904d\u5386,\u6570\u91cf\uff1a{},\u6e38\u6807\uff1a{}", (Object)resultList.size(), (Object)next);
    }

    private void doUpRefresh(CircleNode[] circleNodes, List<MixRecomendResult> resultList, KeyGenerator mixRecordKey, KeyGenerator indexKey, int fromIndex, int num, Long userId, int platform) {
        int total = circleNodes.length;
        if (fromIndex >= total) {
            fromIndex = 0;
            this.mixRecommendService.cleanMixCache(userId, platform);
        }
        int next = fromIndex;
        Set record = this.redisSetAdapter.getAllMembers(mixRecordKey, Long.class);
        for (int i = 0; i < total; ++i) {
            CircleNode circleNode = circleNodes[next];
            this.generateResult(record, mixRecordKey, circleNode, resultList);
            next = circleNode.getNext();
            if (resultList.size() < num) continue;
            this.logger.info("[doUpRefresh]\u5df2\u53d6\u5f97{}\u6761\u6df7\u5408\u63a8\u8350\u6570\u636e\uff0c\u529f\u6210\u5706\u6ee1", (Object)num);
            break;
        }
        if (CollectionUtils.isNotEmpty(resultList)) {
            this.redisSetAdapter.add(mixRecordKey, (Object[])resultList.stream().map(MixRecomendResult::getId).toArray(Long[]::new));
            this.redisSetAdapter.expire(mixRecordKey, (long)NewsCacheThresholdConfig.MIX_EXPIRE_RECOMMENDED_RECORD);
        }
        if (next == fromIndex) {
            this.redisStringAdapter.set(indexKey, (Object)0, (long)NewsCacheThresholdConfig.MIX_EXPIRE_FIX_INDEX);
        } else {
            this.redisStringAdapter.set(indexKey, (Object)next, (long)NewsCacheThresholdConfig.MIX_EXPIRE_FIX_INDEX);
        }
        this.logger.info("[doUpRefresh]\u7ed3\u675f\u904d\u5386,\u6570\u91cf\uff1a{}", (Object)resultList.size());
    }

    private void generateResult(Set<Long> record, KeyGenerator mixRecordKey, CircleNode circleNode, List<MixRecomendResult> resultList) {
        if (!record.contains(circleNode.getId())) {
            MixRecomendResult mixRecomendResult = new MixRecomendResult(Long.valueOf(circleNode.getId()), circleNode.getOrigin());
            resultList.add(mixRecomendResult);
            record.add(circleNode.getId());
        }
    }

    protected void recommendedFilter(CircleNode[] circleNodes, KeyGenerator mixRecordKey, KeyGenerator indexKey, Integer fromIndex, Integer num, Integer actionType, List<MixRecomendResult> resultList, Long userId, int platform) {
        if (actionType.equals(1)) {
            this.doDownRefresh(circleNodes, resultList, mixRecordKey, indexKey, fromIndex, num, userId, platform);
        } else if (actionType.equals(2)) {
            this.doUpRefresh(circleNodes, resultList, mixRecordKey, indexKey, fromIndex, num, userId, platform);
        }
    }
}

