/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.service;

import com.bxm.component.mybatis.utils.MybatisBatchBuilder;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.constant.RedisKeyConstant;
import com.bxm.newidea.domain.UserTagConsumeMapper;
import com.bxm.newidea.vo.UserTag;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class WeightService
extends BaseService {
    private static final long INTERVAL = 1800000L;
    @Resource
    private UserTagConsumeMapper userTagConsumeMapper;
    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;
    @Resource
    private DistributedLock distributedLock;

    public void recalcuUserTagWeight(Long userId) {
        KeyGenerator keyGenerator = RedisKeyConstant.NEWS_RECOMMEND_USER_TAG.copy().appendKey((Object)"interval").appendKey((Object)userId);
        String requestId = String.valueOf(this.nextSequence());
        if (this.distributedLock.lock(keyGenerator.gen(), requestId)) {
            Long lastRecommendTime = (Long)this.redisHashMapAdapter.get(RedisKeyConstant.NEWS_RECOMMEND_INTERVAL, userId.toString(), Long.class);
            long current = System.currentTimeMillis();
            if (lastRecommendTime == null || current - lastRecommendTime > 1800000L) {
                this.redisHashMapAdapter.put(RedisKeyConstant.NEWS_RECOMMEND_INTERVAL, userId.toString(), (Object)current);
                this.execRecalcu(userId);
            }
            this.distributedLock.unlock(keyGenerator.gen(), requestId);
        } else {
            this.logger.info("\u91cd\u7f6e\u7528\u6237\u6807\u7b7e\u51fa\u73b0\u5e76\u53d1\u8bf7\u6c42,\u76f4\u63a5\u5c06\u8be5\u8bf7\u6c42\u820d\u5f03,userId:[{}]", (Object)userId);
        }
    }

    private void execRecalcu(Long userId) {
        List recountTags = this.userTagConsumeMapper.recountUserTags(userId);
        List kindTags = this.userTagConsumeMapper.getKindTags();
        for (UserTag kindTag : kindTags) {
            if (!recountTags.stream().noneMatch(tag -> StringUtils.equals((CharSequence)kindTag.getName(), (CharSequence)tag.getName()))) continue;
            recountTags.add(kindTag);
        }
        boolean removeEmpty = recountTags.removeIf(tag -> tag.getName() == null || "".equals(tag.getName()));
        if (removeEmpty) {
            this.logger.error("[{}]\u63a8\u8350\u7684\u65b0\u95fb\u6807\u7b7e\u5305\u542b\u7a7a\u6807\u7b7e", (Object)userId);
        }
        Date current = new Date();
        recountTags.forEach(e -> {
            e.setId(Long.valueOf(this.nextId()));
            e.setUpdateTime(current);
            e.setUserId(userId);
        });
        this.retry(userId, recountTags);
    }

    private void retry(Long userId, List<UserTag> recountTags) {
        KeyGenerator keyGenerator = RedisKeyConstant.NEWS_RECOMMEND_USER_TAG.copy().appendKey((Object)"recalcu").appendKey((Object)(userId % 10L));
        String requestId = String.valueOf(this.nextSequence());
        if (this.distributedLock.lock(keyGenerator.gen(), requestId)) {
            this.logger.info("\u91cd\u7f6e\u7528\u6237\u6807\u7b7e->\u8fdb\u884c\u5220\u9664\u540e\u65b0\u589e\u64cd\u4f5c\ud83d\udc48,userId:[{}]", (Object)userId);
            this.userTagConsumeMapper.deleteUserTag(userId);
            this.batchSave(recountTags);
            this.distributedLock.unlock(keyGenerator.gen(), requestId);
        } else {
            this.logger.info("\u7528\u6237\u91cd\u7f6e\u6807\u7b7e\u5206\u5e03\u5f0f\u9501\u6b63\u5728\u88ab\u5360\u7528...\u4f11\u606f2S\u540e\u91cd\u8bd5,\u53c2\u6570[{}]", (Object)keyGenerator.gen());
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                this.logger.error("\u7528\u6237\u91cd\u7f6e\u6807\u7b7e\u5206\u5e03\u5f0f\u9501\u4f11\u7720\u5f02\u5e38,\u53c2\u6570:[{}],\u9519\u8bef:[{}]", (Object)keyGenerator.gen(), (Object)e.getMessage());
            }
            this.execRecalcu(userId);
        }
    }

    private void batchSave(List<UserTag> tags) {
        MybatisBatchBuilder.create(UserTagConsumeMapper.class, tags).run(UserTagConsumeMapper::insert);
    }
}

