/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.enums.OperationLocationEnum;
import com.bxm.newidea.param.ForumParam;
import com.bxm.newidea.recommend.engine.ForumRecommendEngine;
import com.bxm.newidea.service.ForumService;
import com.bxm.newidea.vo.CircleNode;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ForumServiceImpl
extends BaseService
implements ForumService {
    private static final Logger LOG = LoggerFactory.getLogger(ForumServiceImpl.class);
    @Autowired
    private ForumRecommendEngine forumRecommendEngine;
    @Autowired
    private RedisListAdapter redisListAdapter;

    @Override
    public List<Long> recommend(ForumParam forumParam) {
        String msg = this.checkParam(forumParam);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            LOG.error("[forum recommend service] parameter error:[{}],\u53c2\u6570:[{}]", (Object)msg, (Object)JSONObject.toJSONString((Object)forumParam));
            return new ArrayList<Long>();
        }
        if (null == forumParam.getPageSize()) {
            forumParam.setPageSize(Integer.valueOf(10));
        }
        return this.forumRecommendEngine.recommend(forumParam);
    }

    @Override
    public void cleanUserTop(Long userId, Long postId) {
    }

    @Override
    public CircleNode[] getCircleNode(List<Long> idList) {
        int length = idList.size();
        CircleNode[] circleNodes = new CircleNode[length];
        int i = 0;
        for (Long id : idList) {
            circleNodes[i] = new CircleNode();
            circleNodes[i].setId(id.longValue());
            circleNodes[i].setNext(i + 1);
            ++i;
        }
        circleNodes[length - 1].setNext(0);
        return circleNodes;
    }

    private String checkParam(ForumParam forumParam) {
        Integer operationId = forumParam.getOperationId();
        StringBuffer sb = new StringBuffer();
        if (null == forumParam.getUserId()) {
            sb.append("\u7528\u6237id\u4e3a\u7a7a").append(",");
        }
        if (null == operationId) {
            sb.append("\u8fd0\u8425\u4f4did\u4e3a\u7a7a").append(",");
        }
        if (StringUtils.isBlank((CharSequence)forumParam.getAreaCode())) {
            sb.append("\u533a\u57df\u7f16\u7801\u4e3a\u7a7a").append(",");
        }
        if (null != operationId && (OperationLocationEnum.FORUM_POST_DETAIL.getCode() == operationId.intValue() || OperationLocationEnum.NOTE_DETAIL.getCode() == operationId.intValue())) {
            if (null == forumParam.getPostId()) {
                sb.append("\u5e16\u5b50id\u4e3a\u7a7a").append(",");
            }
        } else {
            if (null == forumParam.getActionType()) {
                sb.append("\u884c\u4e3a\u6807\u8bb0\u4e3a\u7a7a").append(",");
            }
            if (null != operationId && null == forumParam.getForumId() && (OperationLocationEnum.FORUM_PLATE_ELITE.getCode() == operationId.intValue() || OperationLocationEnum.FORUM_PLATE_NEWEST.getCode() == operationId.intValue())) {
                sb.append("\u677f\u5757id\u4e3a\u7a7a").append(",");
            }
            if (null != operationId && null == forumParam.getTopicId() && StringUtils.isEmpty((CharSequence)forumParam.getChannelIds()) && (OperationLocationEnum.FORUM_TOPIC_HOT.getCode() == operationId.intValue() || OperationLocationEnum.FORUM_TOPIC_NEWEST.getCode() == operationId.intValue())) {
                sb.append("\u8bdd\u9898id\u4e3a\u7a7a").append(",");
            }
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }
}

