/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.service.impl;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.constant.RedisKeyConstant;
import com.bxm.newidea.dto.MixRecomendResult;
import com.bxm.newidea.enums.OperationLocationEnum;
import com.bxm.newidea.service.MixRecommendService;
import com.bxm.newidea.vo.CircleNode;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MixRecommendServiceImpl
extends BaseService
implements MixRecommendService {
    @Autowired
    private RedisListAdapter redisListAdapter;
    @Autowired
    private RedisStringAdapter redisStringAdapter;
    @Autowired
    private RedisSetAdapter redisSetAdapter;

    @Override
    public void cleanMixCache(Long userId, Integer platform) {
        this.logger.debug("[cleanMixCache]\u5220\u9664\u6df7\u5408\u63a8\u8350\u7f13\u5b58\uff0c\u7528\u6237id:[{}],\u5e73\u53f0:[{}]", (Object)userId, (Object)platform);
        KeyGenerator mixRecommendedKey = RedisKeyConstant.FORUM_RECOMMENDED.copy().appendKey((Object)userId).appendKey((Object)platform).appendKey((Object)OperationLocationEnum.HOME_PAGE.getName()).appendKey((Object)"already");
        KeyGenerator mixLastRecommendedKey = RedisKeyConstant.FORUM_RECOMMENDED.copy().appendKey((Object)userId).appendKey((Object)platform).appendKey((Object)OperationLocationEnum.HOME_PAGE.getName()).appendKey((Object)"last");
        KeyGenerator mixLastReadTimeKey = RedisKeyConstant.FORUM_RECOMMENDED.copy().appendKey((Object)userId).appendKey((Object)platform).appendKey((Object)OperationLocationEnum.HOME_PAGE.getName()).appendKey((Object)"lastreadtime");
        KeyGenerator recommendedKey = RedisKeyConstant.FORUM_RECOMMENDED.copy().appendKey((Object)userId).appendKey((Object)platform).appendKey((Object)OperationLocationEnum.FORUM_HOME_PAGE.getName()).appendKey((Object)"already");
        KeyGenerator lastRecommendedKey = RedisKeyConstant.FORUM_RECOMMENDED.copy().appendKey((Object)userId).appendKey((Object)platform).appendKey((Object)OperationLocationEnum.FORUM_HOME_PAGE.getName()).appendKey((Object)"last");
        this.redisSetAdapter.remove(recommendedKey);
        this.redisStringAdapter.remove(lastRecommendedKey);
        this.redisStringAdapter.remove(mixRecommendedKey);
        this.redisListAdapter.remove(mixLastRecommendedKey);
        this.redisListAdapter.remove(mixLastReadTimeKey);
    }

    @Override
    public CircleNode[] getCircleNode(List<MixRecomendResult> mixRecommendResultList) {
        int length = mixRecommendResultList.size();
        CircleNode[] circleNodes = new CircleNode[length];
        int i = 0;
        for (MixRecomendResult mixRecomendResult : mixRecommendResultList) {
            circleNodes[i] = new CircleNode();
            circleNodes[i].setId(mixRecomendResult.getId().longValue());
            circleNodes[i].setOrigin(mixRecomendResult.getOrigin());
            circleNodes[i].setNext(i + 1);
            ++i;
        }
        circleNodes[length - 1].setNext(0);
        return circleNodes;
    }
}

