/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.domain.NewsMapper;
import com.bxm.newidea.dto.VideoDto;
import com.bxm.newidea.recommend.engine.NewsRecommendEngine;
import com.bxm.newidea.recommend.engine.VideoRecommendEngine;
import com.bxm.newidea.recommend.handler.forum.ForumDetailRecommender;
import com.bxm.newidea.service.RecommendService;
import com.bxm.newidea.vo.News;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RecommendServiceImpl
implements RecommendService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private NewsRecommendEngine newsRecommendEngine;
    private VideoRecommendEngine videoRecommendEngine;
    private NewsMapper newsMapper;

    @Autowired(required=false)
    public RecommendServiceImpl(NewsMapper newsMapper, NewsRecommendEngine newsRecommendEngine, VideoRecommendEngine videoRecommendEngine) {
        this.newsMapper = newsMapper;
        this.newsRecommendEngine = newsRecommendEngine;
        this.videoRecommendEngine = videoRecommendEngine;
    }

    @Override
    public List<Long> recommend(Long userId, Integer kindId, Integer pageSize, String areaCode, Integer curPage) {
        return this.newsRecommendEngine.recommendNews(userId, kindId, pageSize, areaCode, curPage);
    }

    @Override
    public List<VideoDto> recommend(Long userId, Integer pageSize) {
        this.logger.info("Video recommend->userId:{},pageSize:{}", (Object)userId, (Object)pageSize);
        return this.videoRecommendEngine.recommendVideo(userId, pageSize);
    }

    @Override
    public List<Long> recommendByNewsDetail(Long userId, Long newsId, Integer size, Integer platform, String areaCode) {
        int newsSize = 5;
        List<Long> ids = new ArrayList<Long>();
        News localNews = this.newsMapper.selectByPrimaryKey(newsId);
        if (null != localNews) {
            if (StringUtils.isNotBlank((CharSequence)localNews.getAreaDetail())) {
                ids = this.localNewsReCommand(localNews, 5, userId);
            } else {
                List list = this.newsMapper.queryRecommendNewsList(newsId, 5, Long.valueOf(userId == null ? 0L : userId), areaCode);
                this.logger.debug("\u5168\u56fd\u77ed\u671f\u65f6\u6548\u8868\u67e5\u627e\u8be6\u60c5\u63a8\u8350\uff1a{}", (Object)JSON.toJSONString((Object)list));
                ids = list.stream().filter(Objects::nonNull).map(News::getId).collect(Collectors.toList());
            }
            ForumDetailRecommender forumDetailRecommender = (ForumDetailRecommender)((Object)SpringContextHolder.getBean(ForumDetailRecommender.class));
            ids = platform == 3 ? forumDetailRecommender.getResultToH5(Sets.newHashSet(ids), localNews.getAreaDetail(), newsId) : forumDetailRecommender.getResultToClient(Sets.newHashSet(ids), 5, localNews.getAreaDetail(), newsId);
        }
        return ids;
    }

    private List<Long> localNewsReCommand(News localNews, Integer size, Long userId) {
        String areaDetail = localNews.getAreaDetail();
        Long province = NumberUtils.toLong((String)areaDetail.substring(0, 2));
        HashSet result = Sets.newHashSet();
        List shortTermList = this.newsMapper.queryRecommendLocalNewsList(localNews.getId(), size, Long.valueOf(userId == null ? 0L : userId), province, areaDetail);
        this.logger.debug("\u672c\u5730\u65b0\u95fb\u77ed\u671f\u65f6\u6548\u8868\u67e5\u627e\u8be6\u60c5\u63a8\u8350(\u6309\u6807\u7b7e\u5339\u914d)\uff1a{}", (Object)JSON.toJSONString((Object)shortTermList));
        result.addAll(shortTermList);
        if (result.size() < size) {
            List localNewsByTime = this.newsMapper.queryLocalNewShortTermByTime(province, userId, size, areaDetail, localNews.getId());
            this.logger.debug("\u5ba1\u6838\u901a\u8fc7\u7684\u672c\u5730\u65b0\u95fb,\u77ed\u671f\u65f6\u6548\uff1a{}", (Object)JSON.toJSONString((Object)localNewsByTime));
            result.addAll(localNewsByTime);
        }
        return result.stream().limit(size.intValue()).collect(Collectors.toList());
    }
}

