package com.bxm.localnews.service;


import com.bxm.localnews.model.param.AdminNewsPageParam;
import com.bxm.localnews.model.param.NewsParam;
import com.bxm.localnews.model.vo.News;
import com.bxm.localnews.model.vo.AdminNews;
import com.bxm.localnews.model.vo.NewsDetail;
import com.bxm.localnews.model.vo.OldNews;

import java.util.List;

public interface NewsService {

    /**
     * 用途：根据关键字查找响应的新闻，根据匹配度排序，返回新闻id
     * 场景：用户在搜索新闻时，输入关键字，得到新闻列表
     * @param adminNewsPageParam
     * @return
     */
    AdminNews selectNews(AdminNewsPageParam adminNewsPageParam);

    /**
     * 用途：根据id列表获得新闻列表的详情
     * 场景：用户在得到新闻列表时，会去搜索引擎中加载新闻的内容
     * @param ids
     * @return
     */
    List<NewsDetail> listNewsDetail(List<Long> ids);

    /**
     * 用途：根据id列表获得新闻列表的详情
     * 场景：用户在得到新闻列表时，会去搜索引擎中加载新闻的内容
     * @param ids
     * @return
     */
    List<News> listNews(List<Long> ids);

    /**
     * 用途：数据同步服务会把经过滤后的数据导入es中，批量进行添加或者更新
     * @param newsParam
     */
    void save(NewsParam newsParam);

    /**
     * 用途：数据同步服务将不合格的数据进行删除
     * @param ids
     */
    void batchDelNews(List<Long> ids);

    /**
     * 用途：数据同步服务会把经过滤后的数据导入es中，批量进行添加或者更新
     * @param newsParam
     */
    void batchSave(List<NewsParam> newsParam);

    /**
     * 用途：根据id列表获得新闻列表的详情[旧]
     * 场景：用户在得到新闻列表时，会去搜索引擎中加载新闻的内容[旧]
     * @param ids
     * @return
     */
    List<OldNews> listOldNewsDetail(List<Long> ids);

    List<News> listTopNews(int size,String areaCode);
}
