/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.config.RedisConfig;
import com.bxm.localnews.model.dto.NewsWarper;
import com.bxm.localnews.model.param.AdminNewsPageParam;
import com.bxm.localnews.model.param.NewsParam;
import com.bxm.localnews.model.vo.AdminNews;
import com.bxm.localnews.model.vo.News;
import com.bxm.localnews.model.vo.NewsDetail;
import com.bxm.localnews.model.vo.OldNews;
import com.bxm.localnews.service.NewsService;
import com.bxm.localnews.utils.ChineseToPinYinUtil;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.DisMaxQueryBuilder;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.functionscore.FunctionScoreQueryBuilder;
import org.elasticsearch.index.query.functionscore.ScoreFunctionBuilder;
import org.elasticsearch.index.query.functionscore.ScoreFunctionBuilders;
import org.elasticsearch.search.sort.ScoreSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.query.Criteria;
import org.springframework.data.elasticsearch.core.query.CriteriaQuery;
import org.springframework.data.elasticsearch.core.query.IndexQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.data.elasticsearch.core.query.UpdateQuery;
import org.springframework.data.elasticsearch.core.query.UpdateQueryBuilder;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class NewsServiceImpl
extends BaseService
implements NewsService {
    private static final Logger logger = LoggerFactory.getLogger(NewsServiceImpl.class);
    @Autowired
    private ElasticsearchOperations elasticsearchOperations;
    @Autowired
    private RedisListAdapter redisListAdapter;

    @Override
    public AdminNews selectNews(AdminNewsPageParam adminNewsPageParam) {
        PageRequest pageable = PageRequest.of((int)adminNewsPageParam.getPageNum(), (int)adminNewsPageParam.getPageSize());
        String key = adminNewsPageParam.getKeyword();
        Integer reviewStatus = adminNewsPageParam.getReviewStatus();
        Integer status = adminNewsPageParam.getStatus();
        Integer kindId = adminNewsPageParam.getKindId();
        Integer showLevel = adminNewsPageParam.getShowLevel();
        String areaCode = adminNewsPageParam.getAreaCode();
        String author = adminNewsPageParam.getAuthor();
        Byte isRecommend = adminNewsPageParam.getIsRecommend();
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        if (StringUtils.isNotEmpty((CharSequence)key)) {
            QueryBuilder keyQueryBuilder = this.queryPageSearch(key);
            queryBuilder.must(keyQueryBuilder);
        }
        if (null != adminNewsPageParam.getId()) {
            queryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"id", (Object)adminNewsPageParam.getId()));
        }
        if (null != isRecommend) {
            queryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"is_recommend", (Object)isRecommend));
        }
        if (null != reviewStatus) {
            queryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"review_status", (Object)reviewStatus));
        }
        if (null != status) {
            queryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"status", (Object)status));
        }
        if (null != kindId) {
            queryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"kind_id", (Object)kindId));
        }
        if (null != author) {
            queryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"author.keyword", (String)author));
        }
        if (adminNewsPageParam.getDeliveryType() != null) {
            if (adminNewsPageParam.getDeliveryType() == 0) {
                queryBuilder.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"area_detail"));
            } else if (StringUtils.isNotEmpty((CharSequence)areaCode)) {
                queryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"area_detail", (String)areaCode));
            } else {
                queryBuilder.must((QueryBuilder)QueryBuilders.existsQuery((String)"area_detail"));
            }
        }
        this.fillingShowLevel(queryBuilder, showLevel, areaCode);
        NativeSearchQuery searchQueryCount = new NativeSearchQueryBuilder().withQuery((QueryBuilder)queryBuilder).build();
        logger.debug("\u65b0\u95fb\u641c\u7d22[\u67e5\u8be2\u6570\u91cf]--->QueryDSL:" + searchQueryCount.getQuery().toString());
        long count = this.elasticsearchOperations.count((SearchQuery)searchQueryCount, News.class);
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery((QueryBuilder)queryBuilder).withSort(SortBuilders.fieldSort((String)"issue_time").order(SortOrder.DESC)).withSort((SortBuilder)new ScoreSortBuilder()).withPageable((Pageable)pageable).build();
        logger.debug("\u65b0\u95fb\u641c\u7d22[\u5206\u9875\u67e5\u8be2]--->QueryDSL:" + searchQuery.getQuery().toString());
        List newsList = this.elasticsearchOperations.queryForList((SearchQuery)searchQuery, NewsWarper.class);
        AdminNews adminNews = new AdminNews();
        adminNews.setNewsList(newsList);
        adminNews.setTotal(Long.valueOf(count));
        return adminNews;
    }

    private void fillingShowLevel(BoolQueryBuilder queryBuilder, Integer showLevel, String areaCode) {
        if (null != showLevel && 0 == showLevel) {
            queryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"top", (int)2));
        } else if (null != showLevel && 1 == showLevel) {
            queryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"hot", (int)2));
        } else if (null != showLevel && 2 == showLevel) {
            queryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"kind_top", (int)2));
        } else if (null != showLevel && 3 == showLevel) {
            queryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"hot", (int)3));
        }
    }

    public QueryBuilder queryPageSearch(String key) {
        AbstractQueryBuilder ngramTitleQueryBuilder = QueryBuilders.matchQuery((String)"title.ngram", (Object)key).analyzer("ngramSearchAnalyzer").boost(5.0f);
        BoolQueryBuilder q1 = QueryBuilders.boolQuery().should((QueryBuilder)ngramTitleQueryBuilder);
        AbstractQueryBuilder ikTitleQueryBuilder = QueryBuilders.matchQuery((String)"title", (Object)key).analyzer("ikSearchAnalyzer").minimumShouldMatch("100%").boost(4.0f);
        BoolQueryBuilder q2 = QueryBuilders.boolQuery().should((QueryBuilder)ikTitleQueryBuilder);
        DisMaxQueryBuilder disMaxQueryBuilder = QueryBuilders.disMaxQuery();
        disMaxQueryBuilder.add((QueryBuilder)q1);
        disMaxQueryBuilder.add((QueryBuilder)q2);
        logger.debug("\u65b0\u95fb\u641c\u7d22[\u5206\u9875\u641c\u7d22]");
        return disMaxQueryBuilder;
    }

    public QueryBuilder chineseSearch(String key) {
        AbstractQueryBuilder pingYinTitleQueryBuilder = QueryBuilders.matchQuery((String)"title.ngram", (Object)key).analyzer("ngramSearchAnalyzer").boost(5.0f);
        AbstractQueryBuilder pingYinContentQueryBuilder = QueryBuilders.matchQuery((String)"content.ngram", (Object)key).analyzer("ngramSearchAnalyzer").boost(2.0f);
        BoolQueryBuilder q1 = QueryBuilders.boolQuery().should((QueryBuilder)pingYinTitleQueryBuilder).should((QueryBuilder)pingYinContentQueryBuilder);
        AbstractQueryBuilder ikTitleQueryBuilder = QueryBuilders.matchQuery((String)"title", (Object)key).analyzer("ikSearchAnalyzer").minimumShouldMatch("100%").boost(4.0f);
        AbstractQueryBuilder ikContentQueryBuilder = QueryBuilders.matchQuery((String)"content", (Object)key).analyzer("ikSearchAnalyzer").minimumShouldMatch("100%").boost(2.0f);
        BoolQueryBuilder q2 = QueryBuilders.boolQuery().should((QueryBuilder)ikTitleQueryBuilder).should((QueryBuilder)ikContentQueryBuilder);
        DisMaxQueryBuilder disMaxQueryBuilder = QueryBuilders.disMaxQuery();
        disMaxQueryBuilder.add((QueryBuilder)q1);
        disMaxQueryBuilder.add((QueryBuilder)q2);
        logger.debug("\u65b0\u95fb\u641c\u7d22[\u7eaf\u4e2d\u6587\u641c\u7d22]");
        return disMaxQueryBuilder;
    }

    private QueryBuilder chineseWithEnglishOrPinyinSearchNews(String key) {
        DisMaxQueryBuilder disMaxQueryBuilder = QueryBuilders.disMaxQuery();
        String startChineseString = ChineseToPinYinUtil.getStartChineseString(key);
        AbstractQueryBuilder normSearchBuilder = QueryBuilders.multiMatchQuery((Object)key, (String[])new String[]{"title.ngram", "content.ngram"}).analyzer("ngramSearchAnalyzer").boost(5.0f);
        String analysisKey = ChineseToPinYinUtil.ToFirstChar(key);
        AbstractQueryBuilder pingYinTitleQueryBuilder = QueryBuilders.termQuery((String)"title.SPY", (String)analysisKey).boost(1.5f);
        AbstractQueryBuilder pingYinContentQueryBuilder = QueryBuilders.termQuery((String)"content.SPY", (String)analysisKey).boost(1.0f);
        BoolQueryBuilder pingYinSampleQueryBuilder = QueryBuilders.boolQuery().should((QueryBuilder)pingYinTitleQueryBuilder).should((QueryBuilder)pingYinContentQueryBuilder);
        BoolQueryBuilder pingYinSampleContainQueryBuilder = null;
        if (analysisKey.length() > 1) {
            AbstractQueryBuilder pingYinTitleSampleContainQueryBuilder = QueryBuilders.wildcardQuery((String)"title.SPY", (String)("*" + analysisKey + "*")).boost(1.2f);
            AbstractQueryBuilder pingYinContentSampleContainQueryBuilder = QueryBuilders.wildcardQuery((String)"content.SPY", (String)("*" + analysisKey + "*")).boost(0.8f);
            pingYinSampleContainQueryBuilder = QueryBuilders.boolQuery().should((QueryBuilder)pingYinTitleSampleContainQueryBuilder).should((QueryBuilder)pingYinContentSampleContainQueryBuilder);
        }
        BoolQueryBuilder pingYinFullQueryBuilder = null;
        if (key.length() > 1) {
            AbstractQueryBuilder pingYinTitleFullContainQueryBuilder = QueryBuilders.matchPhraseQuery((String)"title.FPY", (Object)ChineseToPinYinUtil.ToPinyin(key)).analyzer("pinyiFullSearchAnalyzer").boost(1.5f);
            AbstractQueryBuilder pingYinContentFullContainQueryBuilder = QueryBuilders.matchPhraseQuery((String)"content.FPY", (Object)ChineseToPinYinUtil.ToPinyin(key)).analyzer("pinyiFullSearchAnalyzer").boost(1.0f);
            pingYinFullQueryBuilder = QueryBuilders.boolQuery().should((QueryBuilder)pingYinTitleFullContainQueryBuilder).should((QueryBuilder)pingYinContentFullContainQueryBuilder);
        }
        MultiMatchQueryBuilder containSearchBuilder = QueryBuilders.multiMatchQuery((Object)key, (String[])new String[]{"title", "content"}).analyzer("ikSearchAnalyzer").minimumShouldMatch("100%");
        AbstractQueryBuilder likeSearchBuilder = QueryBuilders.multiMatchQuery((Object)key, (String[])new String[]{"title", "content"}).analyzer("ikSearchAnalyzer").boost(0.5f);
        disMaxQueryBuilder.add((QueryBuilder)normSearchBuilder).add((QueryBuilder)containSearchBuilder).add((QueryBuilder)likeSearchBuilder);
        if (pingYinFullQueryBuilder != null) {
            disMaxQueryBuilder.add((QueryBuilder)pingYinFullQueryBuilder);
        }
        if (pingYinSampleContainQueryBuilder != null) {
            disMaxQueryBuilder.add((QueryBuilder)pingYinSampleContainQueryBuilder);
        }
        DisMaxQueryBuilder queryBuilder = disMaxQueryBuilder;
        if (StringUtils.isNotBlank((CharSequence)startChineseString)) {
            queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)disMaxQueryBuilder).filter((QueryBuilder)QueryBuilders.queryStringQuery((String)("*" + startChineseString + "*")).field("title.ngram").analyzer("ngramSearchAnalyzer"));
            FunctionScoreQueryBuilder.FilterFunctionBuilder[] filterFunctionBuilders = new FunctionScoreQueryBuilder.FilterFunctionBuilder[]{new FunctionScoreQueryBuilder.FilterFunctionBuilder((QueryBuilder)QueryBuilders.multiMatchQuery((Object)startChineseString, (String[])new String[]{"title.ngram", "content.ngram"}).analyzer("ngramSearchAnalyzer"), (ScoreFunctionBuilder)ScoreFunctionBuilders.weightFactorFunction((float)1.5f))};
            queryBuilder = QueryBuilders.functionScoreQuery((QueryBuilder)queryBuilder, (FunctionScoreQueryBuilder.FilterFunctionBuilder[])filterFunctionBuilders);
        }
        logger.debug("\u65b0\u95fb\u641c\u7d22[\u4e2d\u82f1\u6587\u6df7\u5408\u641c\u7d22]");
        return queryBuilder;
    }

    @Override
    public List<NewsDetail> listNewsDetail(List<Long> ids) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termsQuery((String)"id", ids));
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery((QueryBuilder)boolQueryBuilder).build();
        logger.debug("\u65b0\u95fb\u67e5\u8be2\u8be6\u60c5--->QueryDSL:" + searchQuery.getQuery().toString());
        return this.elasticsearchOperations.queryForList((SearchQuery)searchQuery, NewsDetail.class);
    }

    @Override
    public List<News> listNews(List<Long> ids) {
        PageRequest pageable = PageRequest.of((int)0, (int)ids.size());
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termsQuery((String)"id", ids));
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery((QueryBuilder)boolQueryBuilder).withPageable((Pageable)pageable).build();
        logger.debug("\u65b0\u95fb\u6309id\u5217\u8868\u67e5\u8be2--->QueryDSL:" + searchQuery.getQuery().toString());
        return this.elasticsearchOperations.queryForList((SearchQuery)searchQuery, News.class);
    }

    @Override
    @Async
    public void save(NewsParam newsParam) {
        KeyGenerator keyGenerator = RedisConfig.NEWS_ES_QUEUE.copy().setKey("save");
        try {
            News news = this.convertNews(newsParam);
        }
        catch (Exception e) {
            logger.error("es\u65b0\u95fb\u65b0\u589e\u5931\u8d25,id\u4e3a:{}", (Object)newsParam.getId());
            this.redisListAdapter.leftPush(keyGenerator, new Object[]{newsParam.getId()});
        }
    }

    @Override
    @Async
    public void batchDelNews(List<Long> ids) {
        logger.error("\u8fdb\u5165\u5220\u9664\u65b0\u95fb\u6d41\u7a0b,\u53c2\u6570\u4e3a:{}", ids);
        KeyGenerator keyGenerator = RedisConfig.NEWS_ES_QUEUE.copy().setKey("delete");
    }

    @Override
    @Async
    public void batchSave(List<NewsParam> newsParam) {
        logger.warn("\u8fdb\u5165\u6279\u91cf\u65b0\u589e\u65b9\u6cd5");
        this.bulkUpdate(newsParam, "localnews");
    }

    @Override
    public List<OldNews> listOldNewsDetail(List<Long> ids) {
        PageRequest pageable = PageRequest.of((int)0, (int)ids.size());
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termsQuery((String)"id", ids));
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery((QueryBuilder)boolQueryBuilder).withPageable((Pageable)pageable).build();
        logger.debug("\u65b0\u95fb\u6309id\u5217\u8868\u67e5\u8be2--->QueryDSL:" + searchQuery.getQuery().toString());
        return this.elasticsearchOperations.queryForList((SearchQuery)searchQuery, OldNews.class);
    }

    @Override
    public List<News> listTopNews(int size, String areaCode) {
        PageRequest pageable = PageRequest.of((int)0, (int)size);
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"status", (int)1)).must((QueryBuilder)QueryBuilders.termQuery((String)"top", (int)2)).must((QueryBuilder)QueryBuilders.termQuery((String)"review_status", (int)2)).must((QueryBuilder)QueryBuilders.existsQuery((String)"top_expire_time")).must((QueryBuilder)QueryBuilders.rangeQuery((String)"top_expire_time").gte((Object)System.currentTimeMillis()));
        if (StringUtils.isNotEmpty((CharSequence)areaCode)) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"area_detail", (String)areaCode));
        } else {
            boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"area_detail"));
        }
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery((QueryBuilder)boolQueryBuilder).withPageable((Pageable)pageable).withSort(SortBuilders.fieldSort((String)"issue_time").order(SortOrder.DESC)).build();
        logger.debug("\u65b0\u95fb\u67e5\u627e\u7f6e\u9876\u65b0\u95fb\u5217\u8868--->QueryDSL:" + searchQuery.getQuery().toString());
        return this.elasticsearchOperations.queryForList((SearchQuery)searchQuery, News.class);
    }

    private News convertNews(NewsParam newsParam) {
        News news = new News();
        news.setId(String.valueOf(newsParam.getId()));
        news.setTitle(newsParam.getTitle());
        if (newsParam.getIssueTime() != null) {
            // empty if block
        }
        return news;
    }

    private long bulkIndex(List<NewsParam> newsParamList, String indexName, String indexType) {
        int counter = 0;
        try {
            if (!this.elasticsearchOperations.indexExists(indexName)) {
                this.elasticsearchOperations.createIndex(indexName);
            }
            this.elasticsearchOperations.putMapping(News.class);
            ArrayList<IndexQuery> queries = new ArrayList<IndexQuery>();
            for (NewsParam jwrk : newsParamList) {
                IndexQuery indexQuery = new IndexQuery();
                indexQuery.setId(jwrk.getId().toString());
                indexQuery.setSource(JSON.toJSONString((Object)jwrk));
                indexQuery.setIndexName(indexName);
                indexQuery.setType(indexType);
                queries.add(indexQuery);
                if (counter % 500 == 0) {
                    this.elasticsearchOperations.bulkIndex(queries);
                    queries.clear();
                    logger.debug("bulkIndex counter : " + counter);
                }
                ++counter;
            }
            if (queries.size() > 0) {
                this.elasticsearchOperations.bulkIndex(queries);
            }
            this.elasticsearchOperations.refresh(indexName);
            System.out.println("bulkIndex completed.");
        }
        catch (Exception e) {
            System.out.println("IndexerService.bulkIndex e;" + e.getMessage());
            throw e;
        }
        return -1L;
    }

    private long bulkUpdate(List<NewsParam> newsDataList, String indexName) {
        int counter = 0;
        try {
            this.elasticsearchOperations.putMapping(News.class);
            ArrayList<UpdateQuery> queries = new ArrayList<UpdateQuery>();
            long time = System.currentTimeMillis();
            for (NewsParam news : newsDataList) {
                JSONObject map = JSONObject.parseObject((String)JSON.toJSONString((Object)news));
                IndexRequest indexRequest = new IndexRequest();
                indexRequest.source((Map)map);
                UpdateQuery updateQuery = new UpdateQueryBuilder().withId(String.valueOf(news.getId())).withDoUpsert(true).withClass(News.class).withIndexRequest(indexRequest).build();
                queries.add(updateQuery);
                if (++counter == 0 || counter % 5000 != 0) continue;
                this.elasticsearchOperations.bulkUpdate(queries);
                queries.clear();
                logger.warn("bulkUpdate counter : " + counter);
            }
            if (queries.size() > 0) {
                this.elasticsearchOperations.bulkUpdate(queries);
            }
            this.elasticsearchOperations.refresh(indexName);
            logger.warn("bulkUpdate completed.Time is : " + (System.currentTimeMillis() - time));
        }
        catch (Exception e) {
            logger.debug("IndexerService.bulkIndex e;" + e.getMessage());
            throw e;
        }
        return -1L;
    }

    public boolean deleteByIds(List<String> idList) {
        try {
            CriteriaQuery criteriaQuery = new CriteriaQuery(new Criteria());
            criteriaQuery.setIds(idList);
            this.elasticsearchOperations.delete(criteriaQuery, News.class);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

