/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.sync.controller;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.processer.ProcesserChain;
import com.bxm.localnews.processer.ProcesserContext;
import com.bxm.localnews.service.NewsStatisticService;
import com.bxm.localnews.sync.task.SyncNewsPoolJob;
import com.bxm.localnews.sync.vo.local.AdminNews;
import com.bxm.localnews.sync.vo.local.NewsRecommended;
import com.bxm.localnews.sync.vo.local.NewsStatistics;
import com.bxm.localnews.sync.vo.local.NewsStatus;
import com.bxm.localnews.sync.vo.spider.BaseSyncBean;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/news"})
public class NewsSyncController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ProcesserChain processerChain;
    @Autowired
    private NewsStatisticService newsStatisticService;
    @Autowired
    private SyncNewsPoolJob syncNewsPoolJob;

    @PostMapping(value={"/manage/save"})
    @ApiOperation(value="\u8fd0\u8425\u540e\u53f0\u5728\u8fdb\u884c\u64cd\u4f5c\u65f6\uff0c\u4f1a\u8c03\u7528\u6b64\u63a5\u53e3\u8fdb\u884c\u6570\u636e\u5f55\u5165\uff0c\u5177\u4f53\u4e3a\u3010\u65b0\u589e\u65b0\u95fb\u3011\u3010\u4fee\u6539\u65b0\u95fb\u3011")
    public ResponseEntity<Json> save(@RequestBody AdminNews adminNews) {
        this.logger.info("[\u6570\u636e\u66f4\u65b0]\u63a5\u6536\u5230\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)adminNews));
        ProcesserContext context = new ProcesserContext();
        context.setData((BaseSyncBean)adminNews);
        this.processerChain.process(context);
        return new ResponseEntity(HttpStatus.OK);
    }

    @PostMapping(value={"/sync/statistic"})
    @ApiOperation(value="\u65b0\u95fb\u5728\u70b9\u51fb\uff0c\u9605\u8bfb\uff0c\u5206\u4eab\u540e\u5c06\u4f1a\u8c03\u7528\u6b64\u63a5\u53e3\u8fdb\u884c\u6570\u636e\u5f55\u5165")
    public ResponseEntity<Json> updateStatistic(@RequestBody List<NewsStatistics> newsStatisticsList) {
        this.logger.info("[\u9759\u6001\u6570\u636e]\u63a5\u6536\u5230\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(newsStatisticsList));
        this.newsStatisticService.updateStatistic(newsStatisticsList);
        return new ResponseEntity(HttpStatus.OK);
    }

    @PostMapping(value={"/sync/recommended"})
    @ApiOperation(value="\u65b0\u95fb\u5728\u63a8\u8350\u8fc7\u540e\u4f1a\u8c03\u7528\u6b64\u63a5\u53e3\u8fdb\u884c\u6570\u636e\u5f55\u5165\uff0c\u4e3b\u8981\u4e3a\u63a8\u8350\u8bb0\u5f55\u7684\u589e\u52a0\u4ee5\u53ca\u65b0\u95fb\u4e2d\u9759\u6001\u6570\u636e\u63a8\u8350\u6b21\u6570\u7684\u589e\u52a0")
    public ResponseEntity<Json> saveRecommended(@RequestBody List<NewsRecommended> newsRecommendedList) {
        this.logger.info("[\u5df2\u63a8\u8350\u8bb0\u5f55]\u63a5\u6536\u5230\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(newsRecommendedList));
        this.newsStatisticService.saveRecommended(newsRecommendedList);
        return new ResponseEntity(HttpStatus.OK);
    }

    @GetMapping(value={"/sync/newspool"})
    @ApiOperation(value="\u624b\u52a8\u8c03\u7528\u65b0\u95fb\u7f13\u51b2\u6c60")
    public ResponseEntity<Json> syncNewsPool() {
        this.syncNewsPoolJob.service();
        return new ResponseEntity(HttpStatus.OK);
    }

    @PostMapping(value={"/status/update"})
    @ApiOperation(value="\u66f4\u65b0\u65b0\u95fb\u7684\u72b6\u6001\uff08\u5305\u62ec\u5ba1\u6838\u72b6\u6001\uff0c\u662f\u5426\u7f6e\u9876\uff0c\u662f\u5426\u70ed\u95e8\uff09")
    public ResponseEntity<Json> updateStatus(@RequestBody NewsStatus newsStatus) {
        this.logger.info("[\u72b6\u6001\u66f4\u65b0]\u63a5\u6536\u5230\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)newsStatus));
        ProcesserContext context = new ProcesserContext();
        context.setData((BaseSyncBean)newsStatus);
        this.processerChain.process(context);
        return new ResponseEntity(HttpStatus.OK);
    }
}

