package com.bxm.localnews.sync.controller;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.service.NewsInfoSyncService;
import com.bxm.localnews.sync.task.SyncUserRedundancyInfoJob;
import com.bxm.localnews.sync.task.SyncUserStatisticJob;
import com.bxm.localnews.sync.task.SyncNewsCommentJob;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("api/data/sync")
public class DataSyncController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private SyncUserStatisticJob syncUserStatisticJob;

    @Autowired
    private NewsInfoSyncService newsInfoSyncService;

    @Autowired
    private SyncNewsCommentJob syncNewsCommentJob;

    @Autowired
    private SyncUserRedundancyInfoJob syncUserRedundancyInfoJob;

    @GetMapping("/user/static")
    @ApiOperation(value = "更新用户的静态数据 如帖子发布数,评论数")
    public Json calculateUserStatistic() {
        syncUserStatisticJob.service();
        return ResultUtil.genSuccessMsg();
    }

    @GetMapping("/news/static")
    @ApiOperation(value = "更新新闻,帖子,小视频的静态数据")
    public Json calculateNewsStatistic() {
        newsInfoSyncService.execute();
        return ResultUtil.genSuccessMsg();
    }


    @GetMapping("/news/comment/static")
    @ApiOperation(value = "更新新闻评论的静态数据")
    public Json calculateNewsCommentStatistic() {
        syncNewsCommentJob.service();
        return ResultUtil.genSuccessMsg();
    }

    @GetMapping("/user/redundancy")
    @ApiOperation(value = "更新用户在各个表的冗余数据,主要为【帖子点赞】【评论】【帖子】")
    public Json syncUserRedundancyInfo() {
        syncUserRedundancyInfoJob.service();
        return ResultUtil.genSuccessMsg();
    }
}
