package com.bxm.localnews.sync.controller;


import com.alibaba.fastjson.JSON;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.processer.ProcesserChain;
import com.bxm.localnews.processer.ProcesserContext;
import com.bxm.localnews.service.NewsStatisticService;
import com.bxm.localnews.sync.task.SyncNewsPoolJob;
import com.bxm.localnews.sync.vo.local.AdminNews;
import com.bxm.localnews.sync.vo.local.NewsRecommended;
import com.bxm.localnews.sync.vo.local.NewsStatistics;
import com.bxm.localnews.sync.vo.local.NewsStatus;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("api/news")
public class NewsSyncController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ProcesserChain processerChain;

    @Autowired
    private NewsStatisticService newsStatisticService;

    @Autowired
    private SyncNewsPoolJob syncNewsPoolJob;


    @PostMapping("/manage/save")
    @ApiOperation(value =
            "运营后台在进行操作时，会调用此接口进行数据录入，具体为【新增新闻】【修改新闻】" )
    public ResponseEntity<Json> save(@RequestBody AdminNews adminNews) {
        logger.info("[数据更新]接收到参数：{}", JSON.toJSONString(adminNews));
        ProcesserContext<AdminNews> context = new ProcesserContext<>();
        context.setData(adminNews);
        this.processerChain.process(context);
        return new ResponseEntity<>(HttpStatus.OK);
    }

    @PostMapping("/sync/statistic")
    @ApiOperation(value = "新闻在点击，阅读，分享后将会调用此接口进行数据录入")
    public ResponseEntity<Json> updateStatistic(@RequestBody List<NewsStatistics> newsStatisticsList) {
        logger.info("[静态数据]接收到参数：{}", JSON.toJSONString(newsStatisticsList));
        newsStatisticService.updateStatistic(newsStatisticsList);
        return new ResponseEntity<>(HttpStatus.OK);
    }

    @PostMapping("/sync/recommended")
    @ApiOperation(value = "新闻在推荐过后会调用此接口进行数据录入，主要为推荐记录的增加以及新闻中静态数据推荐次数的增加")
    public ResponseEntity<Json> saveRecommended(@RequestBody List<NewsRecommended> newsRecommendedList) {
        logger.info("[已推荐记录]接收到参数：{}", JSON.toJSONString(newsRecommendedList));
        newsStatisticService.saveRecommended(newsRecommendedList);
        return new ResponseEntity<>(HttpStatus.OK);
    }

    @GetMapping("/sync/newspool")
    @ApiOperation(value = "手动调用新闻缓冲池")
    public ResponseEntity<Json> syncNewsPool() {
        syncNewsPoolJob.service();
        return new ResponseEntity<>(HttpStatus.OK);
    }

    @PostMapping("/status/update")
    @ApiOperation(value = "更新新闻的状态（包括审核状态，是否置顶，是否热门）")
    public ResponseEntity<Json> updateStatus(@RequestBody NewsStatus newsStatus) {
        logger.info("[状态更新]接收到参数：{}", JSON.toJSONString(newsStatus));
        ProcesserContext<NewsStatus> context = new ProcesserContext<>();
        context.setData(newsStatus);
        this.processerChain.process(context);
        return new ResponseEntity<>(HttpStatus.OK);
    }
}
