package com.bxm.localnews.sync.controller;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.service.NewsManageService;
import com.bxm.localnews.sync.vo.Keyword;
import com.bxm.localnews.sync.vo.local.PendingContent;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping("api/post")
public class PostSyncController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private NewsManageService newsManageService;

    @PostMapping("/tag/list")
    @ApiOperation(value = "根据传过来的原始数据提取标签信息")
    public ResponseEntity<List<Keyword>> analysisContent(@RequestBody PendingContent pendingContent) {
        logger.info("[提取帖子特征]接收到参数：{}", JSON.toJSONString(pendingContent));
        List<Keyword> list = newsManageService.tfidf(pendingContent.getTitle(), pendingContent.getContent());
        return new ResponseEntity<>(list, HttpStatus.OK);
    }
}
