package com.bxm.localnews.sync.controller;


import com.alibaba.fastjson.JSON;
import com.bxm.localnews.service.NewsManageService;
import com.bxm.localnews.sync.vo.Keyword;

import com.bxm.localnews.sync.vo.local.NewsSimpleParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("api/news/manage")
public class NewsSyncController{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private NewsManageService newsManageService;

    @PostMapping("/save")
    public ResponseEntity<List<Keyword>> save(@RequestBody NewsSimpleParam newsSimpleParam){
        logger.info("接收到参数：{}", JSON.toJSONString(newsSimpleParam));
        List<Keyword> list = newsManageService.tfidf(newsSimpleParam.getTitle(),newsSimpleParam.getContent());
        return new ResponseEntity<>(list,HttpStatus.OK);
    }
}
