package com.bxm.localnews.sync.controller;


import com.bxm.localnews.service.NewsSupplementService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("api/news/sync")
public class NewsSupplementController {

    private static final Logger LOGGER = LoggerFactory.getLogger(NewsSupplementController.class);

    private final NewsSupplementService newsSupplementService;

    @Autowired
    public NewsSupplementController(NewsSupplementService newsSupplementService) {
        this.newsSupplementService = newsSupplementService;
    }

    @GetMapping(value = "")
    public ResponseEntity get() {
        LOGGER.debug("manual sync start");
        newsSupplementService.execute();
        LOGGER.debug("manual sync end");
        return new ResponseEntity<>(HttpStatus.OK);
    }

}
