package com.bxm.localnews.sync.primary.dao;

import com.bxm.localnews.sync.vo.business.ForumPostLike;
import com.bxm.localnews.sync.vo.local.ForumPost;
import com.bxm.localnews.sync.vo.local.ForumPostTopic;
import com.bxm.localnews.sync.vo.local.PostTag;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface ForumPostMapper {

    int calculatePostNumByUser(Long id);

    int savePost(ForumPost forumPost);

    int savePostTopic(ForumPostTopic forumPostTopic);

    List<ForumPost> supplementPostTag();

    List<ForumPost> selectForumPostWithoutUser();

    int savePostTag(PostTag postTag);

    void updateUserInfo(@Param("id") Long id,
                        @Param("userId") Long userId,
                        @Param("userImg") String userImg,
                        @Param("userName") String userName);

    List<ForumPostLike> selectNotExitsUserInfo();

    int updateUserInfoByUserId(ForumPostLike record);
}