package com.bxm.localnews.sync.primary.dao;

import com.bxm.localnews.sync.vo.local.News;
import com.bxm.localnews.sync.vo.local.NewsAging;
import com.bxm.localnews.sync.vo.local.NewsStatistics;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

@Mapper
public interface NewsAgingMapper {

    int save(NewsAging news);

    int deleteById(Long newsId);

    int updateStatisticByPrimaryKeySelective(NewsStatistics newsStatistics);

    /**
     * 查询新闻id进行清理
     * 按时间10天，清理短期表中的新闻数据
     * 其中 16,18,27,33,35,60,61,62,63,64,65,67 不清理 需要额外的逻辑来清理，因为数量太少了
     * 和其中 32,66,69 不清理，因为数量太太太太少了
     * @param limitTime
     * @return
     */
    List<Long> selectByLimitTime(@Param("limitTime") Date limitTime);

    /**
     * 查询新闻id进行清理
     * 暂定为按时间排序1500条以外的数据
     * @param kindId
     * @return
     */
    List<Long> selectByKindId(@Param("kindId") Integer kindId,@Param("size")Integer size);
}
