package com.bxm.localnews.sync.primary.dao;


import com.bxm.localnews.sync.vo.business.NewsCommentStatistic;
import com.bxm.localnews.sync.vo.local.News;
import com.bxm.localnews.sync.vo.local.NewsStatistics;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface NewsMapper {

    int save(News localNews);

    int exists(Long newsId);

    int deleteById(Long newsId);

    int updateStatusById(@Param("id") Long id, @Param("status") Byte status);

    List<News> listNews(@Param("startLimit") long startLimit,@Param("status") Byte status);

    News selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(News news);

    int updateStatusByPrimaryKeySelective(News news);

    int updateStatisticByPrimaryKeySelective(NewsStatistics newsStatistics);

    /**
     * 查询近十日的新闻，更新新闻的评论数
     * @return
     */
    List<Long> getNewsIdByIssueTime();

    int updateNewsCommentById(NewsCommentStatistic newsCommentStatistic);


}
