package com.bxm.localnews.sync.third.dao;

import com.bxm.localnews.sync.vo.business.RecommendNative;
import org.apache.ibatis.annotations.Mapper;

@Mapper
public interface RecommendNativeMapper {

    /**
     * 选择性插入,不为null插入
     * @param recommendNative 实体参数
     * @return 插入结果
     */
    int insertSelective(RecommendNative recommendNative);

    /**
     * 选择行更新
     * @param recommendNative 实体参数
     * @return 更新结果
     */
    int updateBySelective(RecommendNative recommendNative);

    /**
     * 更新用户属性
     * @param recommendNative 实体参数
     * @return 更新结果
     */
    int updateAttribute(RecommendNative recommendNative);

    /**
     * 更新用户行为
     * @param recommendNative 实体参数
     * @return 更新结果
     */
    int updateBehavior(RecommendNative recommendNative);

    /**
     * 更新用户位置
     * @param recommendNative 实体参数
     * @return 更新结果
     */
    int updatePosition(RecommendNative recommendNative);

    /**
     * 根据用户id查询信息
     * @param userId 用户id
     * @return
     */
    RecommendNative selectByUserId(Long userId);

    /**
     * 选择性插入,不为null插入
     * @param recommendNative 实体参数
     * @return 插入结果
     */
    int insertPosition(RecommendNative recommendNative);

    /**
     * 初始化用户推荐信息-保证user_position不为空
     * @param recommendNative 实体参数
     * @return 插入结果
     */
    int initUserRecommendInfo(RecommendNative recommendNative);

}