/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.analysis;

import com.bxm.localnews.analysis.SegmenterService;
import com.bxm.localnews.analysis.loader.DefaultIDFMapLoader;
import com.bxm.localnews.analysis.loader.StopWordLoader;
import com.bxm.localnews.sync.vo.Keyword;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TFIDFAnalyzer {
    private DefaultIDFMapLoader defaultIDFMapLoader;
    private SegmenterService segmenterService;

    @Autowired
    public TFIDFAnalyzer(DefaultIDFMapLoader defaultIDFMapLoader, SegmenterService segmenterService) {
        this.defaultIDFMapLoader = defaultIDFMapLoader;
        this.segmenterService = segmenterService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Keyword> analyze(String title, String content, int topN) {
        TFIDFAnalyzer tFIDFAnalyzer = this;
        synchronized (tFIDFAnalyzer) {
            ArrayList<Keyword> keywordList = new ArrayList<Keyword>();
            List<String> titleSegments = this.getTitleSegments(title);
            List<String> contentSegments = this.getContentSegments(content);
            contentSegments.addAll(titleSegments);
            Map<String, Double> tfMap = this.getTF(contentSegments);
            for (String word : tfMap.keySet()) {
                float coefficient = 1.0f;
                if (titleSegments.contains(word)) {
                    coefficient = 1.5f;
                }
                Double wordIdfVal = this.defaultIDFMapLoader.getIDF(word);
                keywordList.add(new Keyword(word, wordIdfVal * (double)coefficient * tfMap.get(word)));
            }
            Collections.sort(keywordList);
            if (keywordList.size() > topN) {
                return keywordList.subList(0, topN);
            }
            return keywordList;
        }
    }

    private List<String> getTitleSegments(String title) {
        if (StringUtils.isBlank((CharSequence)title)) {
            return new ArrayList<String>();
        }
        return this.segmenterService.seg(title);
    }

    private List<String> getContentSegments(String content) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return new ArrayList<String>();
        }
        return this.segmenterService.seg(content);
    }

    private Map<String, Double> getTF(List<String> segments) {
        HashMap tfMap = Maps.newHashMap();
        HashMap freqMap = Maps.newHashMap();
        int wordSum = 0;
        for (String segment : segments) {
            if (!StopWordLoader.getInstance().isNotStopWord(segment)) continue;
            ++wordSum;
            if (freqMap.containsKey(segment)) {
                freqMap.put(segment, (Integer)freqMap.get(segment) + 1);
                continue;
            }
            freqMap.put(segment, 1);
        }
        for (String word : freqMap.keySet()) {
            tfMap.put(word, (double)((Integer)freqMap.get(word)).intValue() * 0.1 / (double)wordSum);
        }
        return tfMap;
    }
}

