/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.analysis.loader;

import com.bxm.localnews.analysis.loader.StopWordLoader;
import com.bxm.localnews.config.SyncProperties;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultIDFMapLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultIDFMapLoader.class);
    private static Map<String, Double> wordIdfMap = null;
    private Double midIdf = 0.0;
    @Resource
    private SyncProperties syncProperties;

    public void reload() {
        HashMap tempIdfMap = Maps.newHashMap();
        try {
            String line;
            File idfFile = new File(this.syncProperties.getTempDir() + "idf.txt");
            BufferedReader bufferedReader = idfFile.exists() ? new BufferedReader(new FileReader(idfFile)) : new BufferedReader(new InputStreamReader(StopWordLoader.class.getResourceAsStream("/idf.txt")));
            while ((line = bufferedReader.readLine()) != null) {
                String[] kv = line.split(" ");
                tempIdfMap.put(kv[0], Double.valueOf(kv[1]));
            }
            bufferedReader.close();
            ArrayList idfList = new ArrayList(tempIdfMap.values());
            Collections.sort(idfList);
            this.midIdf = (Double)idfList.get(idfList.size() / 2);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        wordIdfMap = tempIdfMap;
    }

    public Double getIDF(String word) {
        Double result;
        if (wordIdfMap == null) {
            this.reload();
        }
        return (result = wordIdfMap.get(word)) == null ? this.midIdf : result;
    }
}

