/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.analysis.loader;

import com.bxm.newidea.component.tools.StringUtils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StopWordLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(StopWordLoader.class);
    private static StopWordLoader stopWordLoader;
    private static Set<String> stopWords;

    private StopWordLoader() {
    }

    public static StopWordLoader getInstance() {
        if (null == stopWordLoader) {
            stopWordLoader = new StopWordLoader();
            StopWordLoader.loadStopWord();
        }
        return stopWordLoader;
    }

    private static void loadStopWord() {
        stopWords = new HashSet<String>();
        try {
            BufferedReader bufr = new BufferedReader(new InputStreamReader(StopWordLoader.class.getResourceAsStream("/stop_words.txt")));
            String line = null;
            while ((line = bufr.readLine()) != null) {
                stopWords.add(line.trim());
            }
            bufr.close();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public boolean isNotStopWord(String word) {
        return StringUtils.isNotBlank((CharSequence)word) && word.length() > 1 && !stopWords.contains(word);
    }
}

