/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.channel;

import com.bxm.localnews.channel.DataChannelService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class DataChannelProxy
implements DataChannelService,
InitializingBean,
ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataChannelProxy.class);
    private ApplicationContext applicationContext;
    private Map<Class<?>, Collection<DataChannelService<?>>> channelList;

    public void save(Object data) {
        for (DataChannelService<?> service : this.getMatchServices(data)) {
            service.clear(data);
            service.save(data);
        }
    }

    public void remove(Object data) {
        for (DataChannelService<?> service : this.getMatchServices(data)) {
            service.remove(data);
        }
    }

    public boolean modify(Object data) {
        boolean result = false;
        for (DataChannelService<?> service : this.getMatchServices(data)) {
            result = service.modify(data);
            if (result) continue;
            return result;
        }
        return result;
    }

    private Collection<DataChannelService<?>> getMatchServices(Object data) {
        Collection<DataChannelService<?>> matchServices = this.channelList.get(data.getClass());
        if (matchServices.size() == 0) {
            LOGGER.error("{}\u6570\u636e\u7c7b\u578b\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5904\u7406\u5668", data.getClass());
        }
        return matchServices;
    }

    public void afterPropertiesSet() {
        Map beans = this.applicationContext.getBeansOfType(DataChannelService.class);
        this.channelList = Maps.newHashMap();
        for (DataChannelService service : beans.values()) {
            ArrayList matchBeans = this.channelList.get(service.supports());
            if (null == matchBeans) {
                matchBeans = Lists.newArrayList();
            }
            matchBeans.add(service);
            this.channelList.put(service.supports(), matchBeans);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

