/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.channel.impl;

import com.bxm.localnews.analysis.TFIDFAnalyzer;
import com.bxm.localnews.channel.DataChannelService;
import com.bxm.localnews.convert.impl.NewsConverter;
import com.bxm.localnews.service.CommonTagService;
import com.bxm.localnews.spider.sync.feign.NewsSearchFeignService;
import com.bxm.localnews.sync.enums.NewsTagTypeEnum;
import com.bxm.localnews.sync.primary.dao.HotnewsAgingMapper;
import com.bxm.localnews.sync.primary.dao.HotnewsAgingRecommendedMapper;
import com.bxm.localnews.sync.primary.dao.LocalnewsAgingMapper;
import com.bxm.localnews.sync.primary.dao.LocalnewsAgingRecommendedMapper;
import com.bxm.localnews.sync.primary.dao.LocalnewsAgingTagMapper;
import com.bxm.localnews.sync.primary.dao.LocalnewsPersistentMapper;
import com.bxm.localnews.sync.primary.dao.LocalnewsPersistentRecommendedMapper;
import com.bxm.localnews.sync.primary.dao.LocalnewsPersistentTagMapper;
import com.bxm.localnews.sync.primary.dao.NewsAgingMapper;
import com.bxm.localnews.sync.primary.dao.NewsAgingRecommendedMapper;
import com.bxm.localnews.sync.primary.dao.NewsAgingTagMapper;
import com.bxm.localnews.sync.primary.dao.NewsMapper;
import com.bxm.localnews.sync.primary.dao.NewsPersistentMapper;
import com.bxm.localnews.sync.primary.dao.NewsPersistentRecommendedMapper;
import com.bxm.localnews.sync.primary.dao.NewsPersistentTagMapper;
import com.bxm.localnews.sync.primary.dao.NewsRecommendedMapper;
import com.bxm.localnews.sync.primary.dao.NewsStatisticsMapper;
import com.bxm.localnews.sync.primary.dao.NewsTagMapper;
import com.bxm.localnews.sync.vo.Keyword;
import com.bxm.localnews.sync.vo.local.HotnewsAging;
import com.bxm.localnews.sync.vo.local.LocalnewsAging;
import com.bxm.localnews.sync.vo.local.News;
import com.bxm.localnews.sync.vo.local.NewsAging;
import com.bxm.localnews.sync.vo.local.NewsRecommended;
import com.bxm.localnews.sync.vo.local.NewsTag;
import com.bxm.newidea.component.tools.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

abstract class AbstractNewsDataChannelServiceImpl<T>
implements DataChannelService<T> {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    NewsStatisticsMapper newsStatisticsMapper;
    @Autowired
    NewsMapper newsMapper;
    @Autowired
    NewsTagMapper newsTagMapper;
    @Autowired
    CommonTagService commonTagService;
    @Autowired
    NewsSearchFeignService newsSearchFeignService;
    @Autowired
    TFIDFAnalyzer tfidfAnalyzer;
    @Autowired
    NewsConverter newsConverter;
    @Autowired
    NewsAgingTagMapper newsAgingTagMapper;
    @Autowired
    NewsAgingMapper newsAgingMapper;
    @Autowired
    NewsPersistentMapper newsPersistentMapper;
    @Autowired
    private NewsPersistentTagMapper newsPersistentTagMapper;
    @Autowired
    protected LocalnewsPersistentMapper localnewsPersistentMapper;
    @Autowired
    private LocalnewsPersistentTagMapper localnewsPersistentTagMapper;
    @Autowired
    protected LocalnewsAgingMapper localnewsAgingMapper;
    @Autowired
    private LocalnewsAgingTagMapper localnewsAgingTagMapper;
    @Autowired
    protected HotnewsAgingMapper hotnewsAgingMapper;
    @Autowired
    protected NewsRecommendedMapper newsRecommendedMapper;
    @Autowired
    protected NewsAgingRecommendedMapper newsAgingRecommendedMapper;
    @Autowired
    protected NewsPersistentRecommendedMapper newsPersistentRecommendedMapper;
    @Autowired
    protected HotnewsAgingRecommendedMapper hotnewsAgingRecommendedMapper;
    @Autowired
    protected LocalnewsPersistentRecommendedMapper localnewsPersistentRecommendedMapper;
    @Autowired
    protected LocalnewsAgingRecommendedMapper localnewsAgingRecommendedMapper;

    AbstractNewsDataChannelServiceImpl() {
    }

    @Override
    void remove(News news) {
        this.clearNewsAging(news);
        this.newsMapper.updateStatusById(news.getId(), news.getStatus());
    }

    void clearNewsTotal(Long newsId) {
        this.newsMapper.deleteById(newsId);
        this.newsTagMapper.deleteByNewsId(newsId);
        this.newsRecommendedMapper.deleteByNewsId(newsId);
    }

    void clearNewsAging(News data) {
        News oldNews = this.newsMapper.selectByPrimaryKey(data.getId());
        if (null != oldNews) {
            this.newsAgingMapper.deleteById(data.getId());
            this.newsPersistentMapper.deleteById(data.getId());
            this.newsAgingTagMapper.deleteByNewsId(data.getId());
            this.newsPersistentTagMapper.deleteByNewsId(data.getId());
            this.newsAgingRecommendedMapper.deleteByNewsId(data.getId());
            this.newsPersistentRecommendedMapper.deleteByNewsId(data.getId());
            if (StringUtils.isNotEmpty((CharSequence)oldNews.getAreaDetail())) {
                List<String> areaCodeList = Arrays.asList(oldNews.getAreaDetail().split(","));
                for (String areaCode : areaCodeList) {
                    Long province = Long.valueOf(areaCode.substring(0, 2));
                    LocalnewsAging localnewsAging = new LocalnewsAging();
                    localnewsAging.setProvince(province);
                    localnewsAging.setId(data.getId());
                    this.localnewsPersistentMapper.deleteByModel(localnewsAging);
                    this.localnewsAgingMapper.deleteByModel(localnewsAging);
                    NewsTag newsTag = new NewsTag();
                    newsTag.setProvince(province);
                    newsTag.setNewsId(data.getId());
                    this.localnewsPersistentTagMapper.deleteByModel(newsTag);
                    this.localnewsAgingTagMapper.deleteByModel(newsTag);
                    NewsRecommended newsRecommended = new NewsRecommended();
                    newsRecommended.setProvince(province);
                    newsRecommended.setNewsId(data.getId());
                    this.localnewsPersistentRecommendedMapper.deleteByModel(newsRecommended);
                    this.localnewsAgingRecommendedMapper.deleteByModel(newsRecommended);
                }
            }
            this.hotnewsAgingMapper.deleteById(data.getId());
            this.hotnewsAgingRecommendedMapper.deleteByNewsId(data.getId());
        }
    }

    void clearDirtyData(News data) {
        this.clearNewsAging(data);
        this.clearNewsTotal(data.getId());
    }

    boolean modifyNews(News news) {
        if (this.newsMapper.exists(news.getId()) > 0) {
            List<Keyword> keywordList = this.tfidfAnalyzer.analyze(news.getTitle(), news.getContent(), 10);
            news.setKeywordList(keywordList);
            this.clearDirtyData(news);
            this.saveNews(news);
            this.logger.debug("\u65b0\u95fb:{}\u72b6\u6001\u53d8\u66f4", (Object)news.getId());
            return true;
        }
        return false;
    }

    List<NewsTag> saveTag(News news) {
        List<NewsTag> newsTagList = this.listNewsTag(news);
        for (NewsTag newsTag : newsTagList) {
            this.newsTagMapper.save(newsTag);
        }
        return newsTagList;
    }

    void saveNationalTag(News news) {
        List<NewsTag> newsTagList = this.listNewsTag(news);
    }

    List<NewsTag> listNewsTag(News news) {
        ArrayList<NewsTag> newsTagList = new ArrayList<NewsTag>();
        if (StringUtils.isNotBlank((CharSequence)news.getKindName())) {
            Keyword keyword = new Keyword();
            keyword.setName(news.getKindName());
            this.saveTag(newsTagList, keyword, NewsTagTypeEnum.TITLE_TAG.getCode(), news.getId());
        }
        if (news.getKeywordList() != null) {
            for (Keyword keyword : news.getKeywordList()) {
                this.saveTag(newsTagList, keyword, NewsTagTypeEnum.CHANNEL_TAG.getCode(), news.getId());
            }
        }
        return newsTagList;
    }

    void saveTag(List<NewsTag> newsTagList, Keyword keyword, Byte type, Long newsId) {
        NewsTag newsTag = new NewsTag();
        newsTag.setAddTime(Calendar.getInstance().getTime());
        newsTag.setName(keyword.getName());
        newsTag.setTagType(type);
        newsTag.setNewsId(newsId);
        if (type.equals(NewsTagTypeEnum.TITLE_TAG.getCode())) {
            newsTag.setWeight(Double.valueOf(0.0));
        } else {
            newsTag.setWeight(Double.valueOf(keyword.getTfidfvalue()));
        }
        newsTag.setTagId(Long.valueOf(this.commonTagService.saveAndGetTag(keyword.getName())));
        newsTagList.add(newsTag);
    }

    void saveNews(News data) {
        List<NewsTag> newsTagList = this.saveTag(data);
        this.newsMapper.save(data);
        if (2 != data.getReviewStatus() || 1 != data.getStatus()) {
            return;
        }
        if (data.getTop() == 2 || data.getKindTop() == 2) {
            return;
        }
        if (data.getHot() == 2) {
            this.putNewsToHotRecommendPool(data, new ArrayList<NewsRecommended>());
            return;
        }
        if (null != data.getAreaDetail()) {
            this.putNewsToLocalRecommendPool(data, newsTagList, new ArrayList<NewsRecommended>());
            return;
        }
        this.putNewsToNationalRecommendPool(data, newsTagList, new ArrayList<NewsRecommended>());
    }

    void updateNews(News data, News oldNews) {
        List newsTagList = this.newsTagMapper.selectByNewsId(data.getId());
        List newsRecommendedList = this.newsRecommendedMapper.selectByNewsId(data.getId());
        data.setModifyTime(new Date());
        this.newsMapper.updateByPrimaryKeySelective(data);
        data.setShares(oldNews.getShares());
        data.setViews(oldNews.getViews());
        data.setRecommends(oldNews.getRecommends());
        data.setComments(oldNews.getComments());
        data.setActiveViews(oldNews.getActiveViews());
        data.setNewClicks(oldNews.getNewClicks());
        if (2 != data.getReviewStatus() || 1 != data.getStatus()) {
            return;
        }
        if (data.getTop() == 2 || data.getKindTop() == 2) {
            return;
        }
        if (data.getHot() == 2) {
            this.putNewsToHotRecommendPool(data, newsRecommendedList);
            return;
        }
        if (null != data.getAreaDetail()) {
            this.putNewsToLocalRecommendPool(data, newsTagList, newsRecommendedList);
            return;
        }
        this.putNewsToNationalRecommendPool(data, newsTagList, newsRecommendedList);
    }

    void putNewsToHotRecommendPool(News data, List<NewsRecommended> newsRecommendedList) {
        if (StringUtils.isNotEmpty((CharSequence)data.getAreaDetail())) {
            List<String> areaCodeList = Arrays.asList(data.getAreaDetail().split(","));
            for (String areaCode : areaCodeList) {
                HotnewsAging hotnewsAging = new HotnewsAging();
                BeanUtils.copyProperties((Object)data, (Object)hotnewsAging);
                hotnewsAging.setId(data.getId());
                hotnewsAging.setAreaCode(areaCode);
                hotnewsAging.setType(Byte.valueOf((byte)1));
                this.hotnewsAgingMapper.save(hotnewsAging);
            }
        } else {
            HotnewsAging hotnewsAging = new HotnewsAging();
            BeanUtils.copyProperties((Object)data, (Object)hotnewsAging);
            hotnewsAging.setId(data.getId());
            hotnewsAging.setAreaCode(null);
            hotnewsAging.setType(Byte.valueOf((byte)1));
            this.hotnewsAgingMapper.save(hotnewsAging);
        }
        for (NewsRecommended newsRecommended : newsRecommendedList) {
            this.hotnewsAgingRecommendedMapper.insert(newsRecommended);
        }
    }

    void putNewsToLocalRecommendPool(News data, List<NewsTag> newsTagList, List<NewsRecommended> newsRecommendedList) {
        Date issueTime = data.getIssueTime();
        Calendar calendar = Calendar.getInstance();
        calendar.add(10, -120);
        Date agingTime = calendar.getTime();
        List<String> areaCodeList = Arrays.asList(data.getAreaDetail().split(","));
        for (String areaCode : areaCodeList) {
            Long province = Long.valueOf(areaCode.substring(0, 2));
            LocalnewsAging localnewsAging = new LocalnewsAging();
            BeanUtils.copyProperties((Object)data, (Object)localnewsAging);
            localnewsAging.setAreaCode(areaCode);
            localnewsAging.setProvince(province);
            localnewsAging.setId(data.getId());
            this.localnewsPersistentMapper.save(localnewsAging);
            if (issueTime.compareTo(agingTime) > 0) {
                this.localnewsAgingMapper.save(localnewsAging);
            }
            for (NewsTag newsTag : newsTagList) {
                newsTag.setProvince(province);
                this.localnewsPersistentTagMapper.save(newsTag);
                if (issueTime.compareTo(agingTime) <= 0) continue;
                this.localnewsAgingTagMapper.save(newsTag);
            }
            for (NewsRecommended newsRecommended : newsRecommendedList) {
                newsRecommended.setProvince(province);
                this.localnewsPersistentRecommendedMapper.insert(newsRecommended);
                if (issueTime.compareTo(agingTime) <= 0) continue;
                this.localnewsAgingRecommendedMapper.insert(newsRecommended);
            }
        }
    }

    void putNewsToNationalRecommendPool(News data, List<NewsTag> newsTagList, List<NewsRecommended> newsRecommendedList) {
        Date issueTime = data.getIssueTime();
        Calendar calendar = Calendar.getInstance();
        calendar.add(10, -120);
        Date agingTime = calendar.getTime();
        NewsAging newsAging = new NewsAging();
        newsAging.setActiveViews(data.getActiveViews()).setId(data.getId()).setComments(data.getComments()).setNewClicks(data.getNewClicks()).setRecommends(data.getRecommends()).setShares(data.getShares()).setCollects(data.getCollects()).setViews(data.getViews()).setKindId(data.getKindId());
        this.newsPersistentMapper.save(newsAging);
        if (issueTime.compareTo(agingTime) > 0) {
            this.newsAgingMapper.save(newsAging);
        }
        for (NewsTag newsTag : newsTagList) {
            if (issueTime.compareTo(agingTime) > 0) {
                this.newsAgingTagMapper.save(newsTag);
            }
            this.newsPersistentTagMapper.save(newsTag);
        }
        for (NewsRecommended newsRecommended : newsRecommendedList) {
            if (issueTime.compareTo(agingTime) > 0) {
                this.newsAgingRecommendedMapper.insert(newsRecommended);
            }
            this.newsPersistentRecommendedMapper.insert(newsRecommended);
        }
    }
}

