/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.channel.impl;

import com.bxm.localnews.channel.DataChannelService;
import com.bxm.localnews.convert.impl.IDataVideoConverter;
import com.bxm.localnews.service.CommonTagService;
import com.bxm.localnews.sync.enums.NewsTagTypeEnum;
import com.bxm.localnews.sync.primary.dao.VideoMapper;
import com.bxm.localnews.sync.primary.dao.VideoTagMapper;
import com.bxm.localnews.sync.vo.Keyword;
import com.bxm.localnews.sync.vo.local.LocalVideo;
import com.bxm.localnews.sync.vo.local.VideoTag;
import com.bxm.localnews.sync.vo.spider.IDataVideo;
import java.util.Calendar;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class IDataVideoChannelServiceImpl
implements DataChannelService<IDataVideo> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IDataVideoChannelServiceImpl.class);
    private final IDataVideoConverter iDataVideoConverter;
    private final VideoMapper videoMapper;
    private VideoTagMapper videoTagMapper;
    private CommonTagService commonTagService;

    @Autowired
    public IDataVideoChannelServiceImpl(VideoMapper videoMapper, IDataVideoConverter iDataVideoConverter, VideoTagMapper videoTagMapper, CommonTagService commonTagService) {
        this.videoMapper = videoMapper;
        this.iDataVideoConverter = iDataVideoConverter;
        this.videoTagMapper = videoTagMapper;
        this.commonTagService = commonTagService;
    }

    @Override
    public void save(IDataVideo data) {
        LocalVideo localVideo = this.iDataVideoConverter.convert(data);
        if (this.videoMapper.exists(localVideo.getId()) == 0) {
            this.videoMapper.save(localVideo);
            if (!CollectionUtils.isEmpty((Collection)localVideo.getKeywordList())) {
                for (Keyword keyword : localVideo.getKeywordList()) {
                    VideoTag videoTag = new VideoTag();
                    videoTag.setAddTime(Calendar.getInstance().getTime());
                    videoTag.setName(keyword.getName());
                    videoTag.setTagType(NewsTagTypeEnum.TITLE_TAG.getCode());
                    videoTag.setWeight(Double.valueOf(keyword.getTfidfvalue()));
                    videoTag.setVideoId(localVideo.getId());
                    videoTag.setTagId(Long.valueOf(this.commonTagService.saveAndGetTag(keyword.getName())));
                    this.videoTagMapper.insert(videoTag);
                }
            }
        }
    }

    @Override
    public void remove(IDataVideo data) {
        this.videoMapper.deleteById(Long.valueOf(data.getId()));
        this.videoTagMapper.removeByVideoId(Long.valueOf(data.getId()));
    }

    @Override
    public boolean modify(IDataVideo data) {
        Long id = Long.valueOf(data.getId());
        if (this.videoMapper.exists(id) != 0) {
            this.remove(data);
            this.save(data);
            LOGGER.debug("\u89c6\u9891\uff1a{}\u88ab\u53d8\u66f4\uff0c\u8fdb\u884c\u6570\u636e\u66f4\u65b0", (Object)data.getId());
            return true;
        }
        return false;
    }

    @Override
    public Class<IDataVideo> supports() {
        return IDataVideo.class;
    }
}

