/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.channel.impl;

import com.bxm.localnews.channel.impl.AbstractNewsDataChannelServiceImpl;
import com.bxm.localnews.sync.primary.dao.NewsMapper;
import com.bxm.localnews.sync.primary.dao.NewsStatisticsMapper;
import com.bxm.localnews.sync.primary.dao.NewsTagMapper;
import com.bxm.localnews.sync.vo.local.News;
import com.bxm.localnews.sync.vo.local.NewsRecommended;
import com.bxm.localnews.sync.vo.local.NewsStatistics;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class NewsRecommendedChannelServiceImpl
extends AbstractNewsDataChannelServiceImpl<NewsRecommended> {
    @Autowired(required=false)
    public NewsRecommendedChannelServiceImpl(NewsMapper newsMapper, NewsStatisticsMapper newsStatisticsMapper, NewsTagMapper newsTagMapper) {
        this.newsMapper = newsMapper;
        this.newsStatisticsMapper = newsStatisticsMapper;
        this.newsTagMapper = newsTagMapper;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(NewsRecommended data) {
        this.logger.debug("\u65b0\u589e\u7528\u6237\u63a8\u8350\u8bb0\u5f55");
        data.setRecommendType(Byte.valueOf((byte)1));
        this.saveRecommended(data);
    }

    @Override
    public void remove(NewsRecommended data) {
    }

    @Override
    public Class<NewsRecommended> supports() {
        return NewsRecommended.class;
    }

    @Override
    public boolean modify(NewsRecommended data) {
        List newsRecommendedList;
        if (this.newsMapper.exists(data.getNewsId()) > 0 && !CollectionUtils.isEmpty((Collection)(newsRecommendedList = this.newsRecommendedMapper.selectByModel(data)))) {
            this.logger.debug("\u8be5\u7528\u6237\u5bf9\u6b64\u65b0\u95fb\u5df2\u6709\u63a8\u8350\u8bb0\u5f55:user:{},news:{}", (Object)data.getUserId(), (Object)data.getNewsId());
            return true;
        }
        return false;
    }

    void saveRecommended(NewsRecommended data) {
        News news = this.newsMapper.selectByPrimaryKey(data.getNewsId());
        try {
            if (null != news) {
                if (2 != news.getReviewStatus() || 1 != news.getStatus()) {
                    return;
                }
                data.setNewsAddTime(new Date());
                this.newsRecommendedMapper.insert(data);
                this.updateNewsStatistic(data);
                if (news.getTop() == 2 || news.getKindTop() == 2) {
                    return;
                }
                if (news.getHot() == 2) {
                    this.putNewsToHotRecommendPool(data);
                    return;
                }
                if (null != news.getAreaDetail()) {
                    this.putNewsToLocalRecommendPool(data, news.getAreaDetail());
                    return;
                }
                this.putNewsToNationalRecommendPool(data);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void putNewsToHotRecommendPool(NewsRecommended data) {
        this.hotnewsAgingRecommendedMapper.insert(data);
    }

    void putNewsToLocalRecommendPool(NewsRecommended data, String areaDetail) {
        List<String> areaCodeList = Arrays.asList(areaDetail.split(","));
        for (String areaCode : areaCodeList) {
            Long province = Long.valueOf(areaCode.substring(0, 2));
            data.setProvince(province);
            this.localnewsAgingRecommendedMapper.insert(data);
            this.localnewsPersistentRecommendedMapper.insert(data);
        }
    }

    void putNewsToNationalRecommendPool(NewsRecommended data) {
        this.newsAgingRecommendedMapper.insert(data);
        this.newsPersistentRecommendedMapper.insert(data);
    }

    void updateNewsStatistic(NewsRecommended data) {
        NewsStatistics newsStatistics = new NewsStatistics();
        newsStatistics.setNewsId(data.getNewsId());
        newsStatistics.setRecommends(Integer.valueOf(1));
        this.newsMapper.updateStatisticByPrimaryKeySelective(newsStatistics);
    }
}

