/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.channel.impl;

import com.bxm.localnews.channel.impl.AbstractNewsDataChannelServiceImpl;
import com.bxm.localnews.sync.primary.dao.NewsMapper;
import com.bxm.localnews.sync.primary.dao.NewsStatisticsMapper;
import com.bxm.localnews.sync.primary.dao.NewsTagMapper;
import com.bxm.localnews.sync.vo.local.News;
import com.bxm.localnews.sync.vo.local.NewsStatistics;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class NewsStatisticDataChannelServiceImpl
extends AbstractNewsDataChannelServiceImpl<NewsStatistics> {
    private final NewsMapper newsMapper;

    @Autowired(required=false)
    public NewsStatisticDataChannelServiceImpl(NewsMapper newsMapper, NewsStatisticsMapper newsStatisticsMapper, NewsTagMapper newsTagMapper) {
        this.newsMapper = newsMapper;
        this.newsStatisticsMapper = newsStatisticsMapper;
        this.newsTagMapper = newsTagMapper;
    }

    @Override
    public void save(NewsStatistics data) {
    }

    @Override
    public void clear(NewsStatistics data) {
    }

    @Override
    public void remove(NewsStatistics data) {
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean modify(NewsStatistics data) {
        return this.modifyNewsStatistics(data);
    }

    @Override
    public Class<NewsStatistics> supports() {
        return NewsStatistics.class;
    }

    boolean modifyNewsStatistics(NewsStatistics data) {
        News news = this.newsMapper.selectByPrimaryKey(data.getNewsId());
        if (news != null) {
            this.updateNews(data, news);
            this.logger.debug("\u65b0\u95fb\u9759\u6001\u6570\u636e\u53d8\u66f4:{}", (Object)news.getId());
            return true;
        }
        return false;
    }

    void updateNews(NewsStatistics data, News news) {
        try {
            if (data.getComments() == null || data.getComments() == 0) {
                this.newsMapper.updateStatisticByPrimaryKeySelective(data);
            }
            if (2 != news.getReviewStatus() || 1 != news.getStatus()) {
                return;
            }
            if (news.getTop() == 2 || news.getKindTop() == 2) {
                return;
            }
            if (news.getHot() == 2) {
                this.putNewsToHotRecommendPool(data);
                return;
            }
            if (null != news.getAreaDetail()) {
                this.putNewsToLocalRecommendPool(data, news.getAreaDetail());
                return;
            }
            this.putNewsToNationalRecommendPool(data);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void putNewsToHotRecommendPool(NewsStatistics data) {
        this.hotnewsAgingMapper.updateStatisticByPrimaryKeySelective(data);
    }

    void putNewsToLocalRecommendPool(NewsStatistics data, String areaDetail) {
        List<String> areaCodeList = Arrays.asList(areaDetail.split(","));
        for (String areaCode : areaCodeList) {
            Long province = Long.valueOf(areaCode.substring(0, 2));
            data.setProvince(province);
            this.localnewsAgingMapper.updateStatisticByPrimaryKeySelective(data);
            this.localnewsPersistentMapper.updateStatisticByPrimaryKeySelective(data);
        }
    }

    void putNewsToNationalRecommendPool(NewsStatistics data) {
        this.newsAgingMapper.updateStatisticByPrimaryKeySelective(data);
        this.newsPersistentMapper.updateStatisticByPrimaryKeySelective(data);
    }
}

