/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.channel.impl;

import com.bxm.component.mybatis.utils.MybatisBatchBuilder;
import com.bxm.localnews.channel.impl.AbstractNewsDataChannelServiceImpl;
import com.bxm.localnews.convert.impl.AdminNewsUpdateConverter;
import com.bxm.localnews.convert.impl.OldNewsConverter;
import com.bxm.localnews.sync.primary.dao.NewsRecommendedMapper;
import com.bxm.localnews.sync.primary.dao.NewsStatisticsMapper;
import com.bxm.localnews.sync.primary.dao.NewsTagMapper;
import com.bxm.localnews.sync.third.dao.OldNewsMapper;
import com.bxm.localnews.sync.vo.business.OldNews;
import com.bxm.localnews.sync.vo.local.News;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class OldNewsDataChannelServiceImpl
extends AbstractNewsDataChannelServiceImpl<OldNews> {
    private final OldNewsConverter converter;
    private final AdminNewsUpdateConverter adminNewsUpdateConverter;
    private final OldNewsMapper oldNewsMapper;

    @Autowired(required=false)
    public OldNewsDataChannelServiceImpl(AdminNewsUpdateConverter adminNewsUpdateConverter, OldNewsMapper oldNewsMapper, NewsStatisticsMapper newsStatisticsMapper, NewsTagMapper newsTagMapper, OldNewsConverter converter) {
        this.converter = converter;
        this.adminNewsUpdateConverter = adminNewsUpdateConverter;
        this.oldNewsMapper = oldNewsMapper;
        this.newsStatisticsMapper = newsStatisticsMapper;
        this.newsTagMapper = newsTagMapper;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(OldNews data) {
        this.saveNews(this.converter.convert(data));
    }

    @Override
    public void clear(OldNews data) {
        this.clearDirtyData(this.converter.convert(data));
    }

    @Override
    public void remove(OldNews data) {
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean modify(OldNews data) {
        return this.modifyNews(this.converter.convert(data));
    }

    @Override
    public Class<OldNews> supports() {
        return OldNews.class;
    }

    @Override
    boolean modifyNews(News news) {
        if (this.newsMapper.exists(news.getId()) > 0) {
            this.clearDirtyData(news);
            this.saveNews(news);
            this.logger.debug("\u65b0\u95fb:{}\u72b6\u6001\u53d8\u66f4", (Object)news.getId());
            return true;
        }
        return false;
    }

    @Override
    void saveNews(News data) {
        List newsTagList = this.oldNewsMapper.selectTagByNewsId(data.getId());
        List newsRecommendedList = this.oldNewsMapper.selectRecommendByNewsId(data.getId());
        this.newsMapper.save(data);
        MybatisBatchBuilder.create(NewsTagMapper.class, (Collection)newsTagList).sessionTemplateName("primarySessionTemplate").run(NewsTagMapper::save);
        MybatisBatchBuilder.create(NewsRecommendedMapper.class, (Collection)newsRecommendedList).sessionTemplateName("primarySessionTemplate").run(NewsRecommendedMapper::insert);
        if (2 != data.getReviewStatus() || 1 != data.getStatus()) {
            return;
        }
        if (data.getTop() == 2 || data.getKindTop() == 2) {
            return;
        }
        if (data.getHot() == 2) {
            this.putNewsToHotRecommendPool(data, newsRecommendedList);
            return;
        }
        if (null != data.getAreaDetail()) {
            this.putNewsToLocalRecommendPool(data, newsTagList, newsRecommendedList);
            return;
        }
        this.putNewsToNationalRecommendPool(data, newsTagList, newsRecommendedList);
    }
}

