/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.channel.impl;

import com.bxm.localnews.channel.impl.AbstractNewsDataChannelServiceImpl;
import com.bxm.localnews.convert.impl.PhpNewsConverter;
import com.bxm.localnews.sync.vo.local.News;
import java.util.Random;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class PhpNewsChannelServiceImpl
extends AbstractNewsDataChannelServiceImpl<News> {
    private final PhpNewsConverter phpNewsConverter;

    @Autowired
    public PhpNewsChannelServiceImpl(PhpNewsConverter phpNewsConverter) {
        this.phpNewsConverter = phpNewsConverter;
    }

    public static void main(String[] args) {
        Random random = new Random(3L);
        System.out.println(random.nextInt(3));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(News data) {
        News localNews = this.phpNewsConverter.convert(data);
        localNews.setKindName(this.phpNewsConverter.getKind(localNews.getKindId()).getName());
        this.saveNews(localNews);
    }

    @Override
    public void remove(News data) {
        this.newsMapper.updateStatusById(data.getId(), data.getStatus());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean modify(News data) {
        return this.modifyNews(this.phpNewsConverter.convert(data));
    }

    @Override
    public void clear(News data) {
        News news = new News();
        news.setId(data.getId());
        news.setStatus(data.getStatus());
        this.clearDirtyData(news);
    }

    @Override
    public Class<News> supports() {
        return News.class;
    }
}

