/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.convert.impl;

import com.bxm.localnews.convert.Converter;
import com.bxm.localnews.sync.primary.dao.NewsKindMapper;
import com.bxm.localnews.sync.third.dao.LocationMapper;
import com.bxm.localnews.sync.vo.local.Location;
import com.bxm.localnews.sync.vo.local.NewsKind;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

abstract class AbstractConverter<T, K>
implements Converter<T, K> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<NewsKind> kinds;
    private long lastSyncTime;
    private long expireTime = 300000L;
    @Autowired
    private NewsKindMapper newsKindMapper;
    @Autowired
    private LocationMapper locationMapper;
    private ObjectMapper objectMapper = new ObjectMapper();

    AbstractConverter() {
    }

    Integer getKindId(String kindName) {
        Optional<NewsKind> kind = this.getKinds().stream().filter(newsKind -> newsKind.getName().equals(kindName.trim())).findFirst();
        return kind.isPresent() ? kind.get().getId() : 0;
    }

    Location getLocation(String code) {
        return this.locationMapper.findByCode(code);
    }

    boolean hasKindId(int kindId) {
        return this.getKinds().stream().anyMatch(kind -> kind.getId() == kindId);
    }

    public NewsKind getKind(int kindId) {
        return this.getKinds().stream().filter(kind -> kindId == kind.getId()).findFirst().orElse(new NewsKind());
    }

    String toJsonString(Object obj) {
        try {
            return this.objectMapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            this.logger.error(obj + "\u89e3\u6790\u51fa\u9519", (Throwable)e);
            return "";
        }
    }

    private List<NewsKind> getKinds() {
        if (null == this.kinds || System.currentTimeMillis() - this.lastSyncTime > this.expireTime) {
            this.kinds = this.newsKindMapper.selectAllKinds();
            this.lastSyncTime = System.currentTimeMillis();
        }
        return this.kinds;
    }
}

