/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.convert.impl;

import com.bxm.localnews.convert.impl.AbstractConverter;
import com.bxm.localnews.sync.enums.LocalNewStatusEnum;
import com.bxm.localnews.sync.enums.LocalNewsTypeEnum;
import com.bxm.localnews.sync.vo.local.News;
import com.bxm.localnews.sync.vo.spider.SpiderNews;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.RandomUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.github.pagehelper.util.StringUtil;
import org.springframework.stereotype.Component;

@Component
public class NewsConverter
extends AbstractConverter<SpiderNews, News> {
    @Override
    public News convert(SpiderNews spiderNews) {
        News localNews = new News();
        localNews.setId(spiderNews.getId());
        localNews.setContent(spiderNews.getContent());
        localNews.setTitle(spiderNews.getTitle());
        String[] imgArray = StringUtils.isEmpty((CharSequence)spiderNews.getImgUrl()) ? null : spiderNews.getImgUrl().split(";");
        localNews.setImgUrl(imgArray == null ? "" : this.toJsonString(imgArray));
        localNews.setAuthor(StringUtils.isEmpty((CharSequence)spiderNews.getSource()) ? "\u533f\u540d" : spiderNews.getSource());
        localNews.setAddress(spiderNews.getUrl());
        localNews.setAddTime(spiderNews.getCreateTime());
        localNews.setModifyTime(spiderNews.getCreateTime());
        if (StringUtils.isNotEmpty((CharSequence)spiderNews.getDeployTime())) {
            localNews.setIssueTime(DateUtils.parseDateNonStrict((String)spiderNews.getDeployTime()));
        } else {
            localNews.setIssueTime(spiderNews.getCreateTime());
        }
        localNews.setStatus(LocalNewStatusEnum.ENABLE.getCode());
        localNews.setType(LocalNewsTypeEnum.NEWS.getCode());
        localNews.setTop(Byte.valueOf((byte)1));
        localNews.setHot(Byte.valueOf((byte)1));
        localNews.setChannel(Byte.valueOf((byte)8));
        localNews.setKindId(this.getKindId(spiderNews.getChannel()));
        localNews.setKindName(spiderNews.getChannel());
        localNews.setKeywordList(spiderNews.getKeywordList());
        localNews.setSource(spiderNews.getSource());
        localNews.setClicks(Integer.valueOf(RandomUtils.nextInt((int)2000, (int)9000)));
        localNews.setViews(Integer.valueOf(RandomUtils.nextInt((int)1000, (int)5000)));
        localNews.setCollects(Integer.valueOf(0));
        localNews.setComments(Integer.valueOf(0));
        localNews.setRecommends(Integer.valueOf(100));
        localNews.setActiveViews(Integer.valueOf(RandomUtils.nextInt((int)500, (int)2000)));
        localNews.setShares(Integer.valueOf(0));
        localNews.setNewClicks(Integer.valueOf(RandomUtils.nextInt((int)1000, (int)5000)));
        localNews.setReviewStatus(Byte.valueOf((byte)2));
        localNews.setKindTop(Byte.valueOf((byte)1));
        if (StringUtil.isNotEmpty((String)spiderNews.getRegion())) {
            localNews.setAreaDetail(spiderNews.getRegion());
            localNews.setReviewStatus(Byte.valueOf((byte)0));
            this.logger.info("news info :{};{}", (Object)localNews.getTitle(), (Object)localNews.getDeliveryType());
        }
        return localNews;
    }
}

