/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.convert.impl;

import com.bxm.localnews.convert.impl.AbstractConverter;
import com.bxm.localnews.sync.enums.LocalNewStatusEnum;
import com.bxm.localnews.sync.enums.LocalNewsTypeEnum;
import com.bxm.localnews.sync.vo.local.News;
import com.bxm.localnews.sync.vo.spider.SpiderWechatNews;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.RandomUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.github.pagehelper.util.StringUtil;
import org.springframework.stereotype.Component;

@Component
public class WechatNewsConverter
extends AbstractConverter<SpiderWechatNews, News> {
    @Override
    public News convert(SpiderWechatNews spiderWechatNews) {
        News localNews = new News();
        localNews.setId(spiderWechatNews.getId());
        localNews.setViews(Integer.valueOf(0));
        localNews.setTitle(spiderWechatNews.getTitle());
        localNews.setContent(spiderWechatNews.getContent());
        String[] imgArray = StringUtils.isEmpty((CharSequence)spiderWechatNews.getImgUrl()) ? null : spiderWechatNews.getImgUrl().split(";");
        localNews.setImgUrl(imgArray == null ? "" : this.toJsonString(imgArray));
        localNews.setAddress("");
        localNews.setAuthor(StringUtils.isEmpty((CharSequence)spiderWechatNews.getSource()) ? "\u533f\u540d" : spiderWechatNews.getSource());
        localNews.setShares(Integer.valueOf(0));
        localNews.setViews(Integer.valueOf(0));
        localNews.setAddTime(spiderWechatNews.getCreateTime());
        if (StringUtils.isNotEmpty((CharSequence)spiderWechatNews.getDeployTime())) {
            localNews.setIssueTime(DateUtils.parseDateNonStrict((String)spiderWechatNews.getDeployTime()));
        } else {
            localNews.setIssueTime(spiderWechatNews.getCreateTime());
        }
        localNews.setStatus(LocalNewStatusEnum.ENABLE.getCode());
        localNews.setType(LocalNewsTypeEnum.NEWS.getCode());
        localNews.setTop(Byte.valueOf((byte)1));
        localNews.setKindTop(Byte.valueOf((byte)1));
        localNews.setHot(Byte.valueOf((byte)1));
        localNews.setChannel(Byte.valueOf((byte)9));
        localNews.setSource(spiderWechatNews.getSource());
        localNews.setClicks(Integer.valueOf(RandomUtils.nextInt((int)2000, (int)9000)));
        localNews.setViews(Integer.valueOf(RandomUtils.nextInt((int)1000, (int)5000)));
        localNews.setCollects(Integer.valueOf(0));
        localNews.setComments(Integer.valueOf(0));
        localNews.setRecommends(Integer.valueOf(100));
        localNews.setActiveViews(Integer.valueOf(RandomUtils.nextInt((int)500, (int)2000)));
        localNews.setShares(Integer.valueOf(0));
        localNews.setNewClicks(Integer.valueOf(RandomUtils.nextInt((int)1000, (int)5000)));
        localNews.setReviewStatus(Byte.valueOf((byte)2));
        if (StringUtil.isNotEmpty((String)spiderWechatNews.getRegion())) {
            localNews.setAreaDetail(spiderWechatNews.getRegion());
            localNews.setReviewStatus(Byte.valueOf((byte)0));
            this.logger.info("news info :{};{}", (Object)localNews.getTitle(), (Object)localNews.getDeliveryType());
        }
        localNews.setKindId(this.getKindId(spiderWechatNews.getChannel()));
        localNews.setKindName(spiderWechatNews.getChannel());
        return localNews;
    }
}

