/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.processer.impl;

import com.bxm.localnews.analysis.TFIDFAnalyzer;
import com.bxm.localnews.processer.AbstractProcesser;
import com.bxm.localnews.processer.ProcesserContext;
import com.bxm.localnews.sync.vo.Keyword;
import com.bxm.localnews.sync.vo.spider.IDataVideo;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class IDataVideoKeywordProcesser
extends AbstractProcesser {
    private final TFIDFAnalyzer tfidfAnalyzer;

    @Autowired
    public IDataVideoKeywordProcesser(TFIDFAnalyzer tfidfAnalyzer) {
        this.tfidfAnalyzer = tfidfAnalyzer;
    }

    @Override
    protected boolean execute(ProcesserContext context) {
        IDataVideo video = (IDataVideo)context.getData();
        if (CollectionUtils.isEmpty((Collection)video.getVideoUrls())) {
            return false;
        }
        List<Keyword> keywordList = this.tfidfAnalyzer.analyze(video.getTitle(), video.getDescription(), 5);
        video.setKeywordList(keywordList);
        return true;
    }

    @Override
    public boolean match(Object data) {
        return data instanceof IDataVideo;
    }
}

