/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.processer.impl;

import com.bxm.localnews.analysis.TFIDFAnalyzer;
import com.bxm.localnews.analysis.loader.DefaultIDFMapLoader;
import com.bxm.localnews.config.SyncProperties;
import com.bxm.localnews.processer.AbstractProcesser;
import com.bxm.localnews.processer.ProcesserContext;
import com.bxm.localnews.sync.vo.Keyword;
import com.bxm.localnews.sync.vo.local.AdminNews;
import com.bxm.localnews.sync.vo.local.News;
import com.bxm.localnews.sync.vo.spider.SpiderNews;
import com.bxm.localnews.sync.vo.spider.SpiderWechatNews;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NewsKeywordProcesser
extends AbstractProcesser {
    private final TFIDFAnalyzer tfidfAnalyzer;
    private SyncProperties syncProperties;
    private DefaultIDFMapLoader defaultIDFMapLoader;

    @Autowired
    public NewsKeywordProcesser(TFIDFAnalyzer tfidfAnalyzer, SyncProperties syncProperties, DefaultIDFMapLoader defaultIDFMapLoader) {
        this.tfidfAnalyzer = tfidfAnalyzer;
        this.syncProperties = syncProperties;
        this.defaultIDFMapLoader = defaultIDFMapLoader;
    }

    @Override
    protected boolean execute(ProcesserContext context) {
        Object data = context.getData();
        if (data instanceof SpiderNews) {
            SpiderNews news = (SpiderNews)data;
            List<Keyword> keywordList = null;
            keywordList = StringUtils.isNotBlank((CharSequence)news.getKeyword()) ? this.convertKeywords(news.getKeyword()) : this.tfidfAnalyzer.analyze(news.getTitle(), news.getContent(), this.syncProperties.getTagPickCount());
            news.setKeywordList(keywordList);
        } else if (data instanceof SpiderWechatNews) {
            SpiderWechatNews wechatNews = (SpiderWechatNews)data;
            List<Keyword> keywordList = this.tfidfAnalyzer.analyze(wechatNews.getTitle(), wechatNews.getContent(), this.syncProperties.getTagPickCount());
            wechatNews.setKeywordList(keywordList);
        } else if (data instanceof News) {
            News localNews = (News)data;
            List<Keyword> keywordList = this.tfidfAnalyzer.analyze(localNews.getTitle(), localNews.getContent(), this.syncProperties.getTagPickCount());
            localNews.setKeywordList(keywordList);
        } else if (data instanceof AdminNews) {
            AdminNews adminNews = (AdminNews)data;
            List<Keyword> keywordList = this.tfidfAnalyzer.analyze(adminNews.getTitle(), adminNews.getContent(), this.syncProperties.getTagPickCount());
            adminNews.setKeywordList(keywordList);
        }
        return true;
    }

    private List<Keyword> convertKeywords(String keywords) {
        keywords = StringUtils.replaceAll((String)keywords, (String)"\uff0c", (String)",");
        keywords = StringUtils.replaceAll((String)keywords, (String)" ", (String)",");
        String[] keywordArray = StringUtils.split((String)keywords, (String)",");
        ArrayList keywordList = Lists.newArrayList();
        for (String keyword : keywordArray) {
            Keyword keywordObj = new Keyword();
            keywordObj.setName(keyword);
            keywordObj.setTfidfvalue(this.defaultIDFMapLoader.getIDF(keyword).doubleValue());
            keywordList.add(keywordObj);
        }
        return keywordList;
    }

    @Override
    public boolean match(Object data) {
        return data instanceof SpiderNews || data instanceof SpiderWechatNews || data instanceof News || data instanceof AdminNews;
    }
}

