/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.processer.impl;

import com.bxm.localnews.analysis.TFIDFAnalyzer;
import com.bxm.localnews.processer.AbstractProcesser;
import com.bxm.localnews.processer.ProcesserContext;
import com.bxm.localnews.sync.vo.Keyword;
import com.bxm.localnews.sync.vo.spider.SpiderVideo;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VideoKeywordProcesser
extends AbstractProcesser {
    private final TFIDFAnalyzer tfidfAnalyzer;

    @Autowired
    public VideoKeywordProcesser(TFIDFAnalyzer tfidfAnalyzer) {
        this.tfidfAnalyzer = tfidfAnalyzer;
    }

    @Override
    protected boolean execute(ProcesserContext context) {
        SpiderVideo video = (SpiderVideo)context.getData();
        List<Keyword> keywordList = this.tfidfAnalyzer.analyze(video.getTitle(), video.getDesc(), 5);
        video.setKeywordList(keywordList);
        return true;
    }

    @Override
    public boolean match(Object data) {
        return data instanceof SpiderVideo;
    }
}

