/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.service;

import com.bxm.localnews.constant.RedisKey;
import com.bxm.localnews.processer.ProcesserChain;
import com.bxm.localnews.processer.ProcesserContext;
import com.bxm.localnews.sync.second.dao.SpiderCouponGoodsMapper;
import com.bxm.localnews.sync.vo.spider.SpiderCouponGoods;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CouponService
extends BaseService {
    private final RedisStringAdapter redisStringAdapter;
    private final SpiderCouponGoodsMapper spiderCouponGoodsMapper;
    private final ProcesserChain processerChain;

    @Autowired
    public CouponService(RedisStringAdapter redisStringAdapter, SpiderCouponGoodsMapper spiderCouponGoodsMapper, ProcesserChain processerChain) {
        this.redisStringAdapter = redisStringAdapter;
        this.spiderCouponGoodsMapper = spiderCouponGoodsMapper;
        this.processerChain = processerChain;
    }

    public void sync() {
        Date lastSyncTime = (Date)this.redisStringAdapter.get(RedisKey.SPIDER_COUPON_SYNC, Date.class);
        if (null == lastSyncTime) {
            Calendar calendar = Calendar.getInstance();
            calendar.add(6, -14);
            lastSyncTime = calendar.getTime();
        }
        this.excute(lastSyncTime);
    }

    private void excute(Date limitDate) {
        List list = this.spiderCouponGoodsMapper.listForSync(limitDate, BigDecimal.valueOf(9.9), Byte.valueOf((byte)1));
        if (list == null || list.isEmpty()) {
            return;
        }
        for (SpiderCouponGoods spiderCouponGoods : list) {
            ProcesserContext<SpiderCouponGoods> context = new ProcesserContext<SpiderCouponGoods>();
            context.setData(spiderCouponGoods);
            this.processerChain.process(context);
        }
        SpiderCouponGoods spiderCouponGoods = (SpiderCouponGoods)list.get(list.size() - 1);
        this.redisStringAdapter.set(RedisKey.SPIDER_COUPON_SYNC, (Object)spiderCouponGoods.getModifyTime());
        this.excute(spiderCouponGoods.getModifyTime());
    }
}

