/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.service;

import com.bxm.localnews.constant.RedisKey;
import com.bxm.localnews.processer.ProcesserChain;
import com.bxm.localnews.processer.ProcesserContext;
import com.bxm.localnews.sync.second.dao.SpiderNewsContentMapper;
import com.bxm.localnews.sync.second.dao.SpiderNewsMapper;
import com.bxm.localnews.sync.vo.spider.SpiderNews;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NewsSyncService {
    private static final Logger logger = LoggerFactory.getLogger(NewsSyncService.class);
    private final SpiderNewsMapper spiderNewsMapper;
    private final SpiderNewsContentMapper spiderNewsContentMapper;
    private final RedisStringAdapter redisStringAdapter;
    private final ProcesserChain processerChain;

    @Autowired
    public NewsSyncService(SpiderNewsMapper spiderNewsMapper, SpiderNewsContentMapper spiderNewsContentMapper, RedisStringAdapter redisStringAdapter, ProcesserChain processerChain) {
        this.spiderNewsMapper = spiderNewsMapper;
        this.spiderNewsContentMapper = spiderNewsContentMapper;
        this.redisStringAdapter = redisStringAdapter;
        this.processerChain = processerChain;
    }

    public void sync(Integer offset) {
        String tableName = "news_" + offset;
        String contentTable = "news_content_" + offset;
        KeyGenerator syncKey = RedisKey.SPIDER_NEWS_SYNC.copy().appendKey((Object)offset);
        Date lastModifyTime = (Date)this.redisStringAdapter.get(syncKey, Date.class);
        if (null == lastModifyTime) {
            lastModifyTime = DateUtils.addField((Date)new Date(), (int)6, (int)-14);
        }
        this.excute(tableName, contentTable, lastModifyTime, syncKey, 0L);
    }

    private void excute(String newsTableName, String contentTableName, Date limitDate, KeyGenerator syncKey, long id) {
        List list = this.spiderNewsMapper.listForSync(Long.valueOf(id), newsTableName, limitDate);
        if (list == null || list.isEmpty()) {
            return;
        }
        for (SpiderNews news : list) {
            news.setContent(this.spiderNewsContentMapper.findById(contentTableName, news.getId()));
            ProcesserContext<SpiderNews> context = new ProcesserContext<SpiderNews>();
            context.setData(news);
            this.processerChain.process(context);
        }
        SpiderNews lastNews = (SpiderNews)list.get(list.size() - 1);
        this.redisStringAdapter.set(syncKey, (Object)lastNews.getModifyTime());
        this.excute(newsTableName, contentTableName, limitDate, syncKey, lastNews.getId());
    }
}

