/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.service;

import com.bxm.localnews.constant.RedisKey;
import com.bxm.localnews.processer.ProcesserChain;
import com.bxm.localnews.processer.ProcesserContext;
import com.bxm.localnews.spider.sync.feign.NewsSearchFeignService;
import com.bxm.localnews.sync.dto.ESNewsContentDTO;
import com.bxm.localnews.sync.third.dao.OldNewsMapper;
import com.bxm.localnews.sync.vo.business.OldNews;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class OldLocalNewsSyncService {
    private static final Logger logger = LoggerFactory.getLogger(OldLocalNewsSyncService.class);
    private final OldNewsMapper oldNewsMapper;
    private final NewsSearchFeignService newsSearchFeignService;
    private final RedisStringAdapter redisStringAdapter;
    private final ProcesserChain processerChain;

    @Autowired
    public OldLocalNewsSyncService(OldNewsMapper oldNewsMapper, NewsSearchFeignService newsSearchFeignService, RedisStringAdapter redisStringAdapter, ProcesserChain processerChain) {
        this.oldNewsMapper = oldNewsMapper;
        this.newsSearchFeignService = newsSearchFeignService;
        this.redisStringAdapter = redisStringAdapter;
        this.processerChain = processerChain;
    }

    public void sync() {
        KeyGenerator syncKey = RedisKey.OLD_LOCAL_NEWS_NEWS_SYNC;
        Date lastModifyTime = (Date)this.redisStringAdapter.get(syncKey, Date.class);
        if (null == lastModifyTime) {
            String time = "1994-01-20 00:00:00";
            lastModifyTime = DateUtils.parseDateTime((String)time);
        }
        this.excute(lastModifyTime, syncKey, 0L);
    }

    private void excute(Date limitDate, KeyGenerator syncKey, long id) {
        List list = this.oldNewsMapper.listLocalForSync(Long.valueOf(id), limitDate);
        if (list == null || list.isEmpty()) {
            return;
        }
        for (OldNews news : list) {
            news.setContent(this.getContent(news.getId()));
            ProcesserContext<OldNews> context = new ProcesserContext<OldNews>();
            context.setData(news);
            this.processerChain.process(context);
        }
        OldNews lastNews = (OldNews)list.get(list.size() - 1);
        this.redisStringAdapter.set(syncKey, (Object)lastNews.getIssueTime());
        this.excute(lastNews.getIssueTime(), syncKey, 0L);
    }

    private String getContent(Long newsId) {
        List body;
        Long[] ids = new Long[]{newsId};
        ResponseEntity responseEntity = this.newsSearchFeignService.get(ids);
        if (responseEntity != null && !CollectionUtils.isEmpty((Collection)(body = (List)responseEntity.getBody()))) {
            return ((ESNewsContentDTO)body.get(0)).getContent();
        }
        return null;
    }
}

