/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.service;

import com.bxm.localnews.constant.RedisKey;
import com.bxm.localnews.processer.ProcesserChain;
import com.bxm.localnews.processer.ProcesserContext;
import com.bxm.localnews.sync.second.dao.PhpSpiderNewsMapper;
import com.bxm.localnews.sync.vo.local.News;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PhpNewsSyncService {
    private static final Logger logger = LoggerFactory.getLogger(PhpNewsSyncService.class);
    private final PhpSpiderNewsMapper phpSpiderNewsMapper;
    private final RedisStringAdapter redisStringAdapter;
    private final ProcesserChain processerChain;

    @Autowired(required=false)
    public PhpNewsSyncService(PhpSpiderNewsMapper phpSpiderNewsMapper, RedisStringAdapter redisStringAdapter, ProcesserChain processerChain) {
        this.phpSpiderNewsMapper = phpSpiderNewsMapper;
        this.redisStringAdapter = redisStringAdapter;
        this.processerChain = processerChain;
    }

    public synchronized void sync() {
        Date limitDate = (Date)this.redisStringAdapter.get(RedisKey.SPIDER_PHP_SYNC, Date.class);
        if (null == limitDate) {
            Calendar calendar = Calendar.getInstance();
            calendar.add(6, -14);
            limitDate = calendar.getTime();
        }
        this.execute(limitDate);
    }

    private void execute(Date limitDate) {
        List list = this.phpSpiderNewsMapper.listForSync(limitDate);
        if (list == null || list.isEmpty()) {
            return;
        }
        for (News news : list) {
            ProcesserContext<News> context = new ProcesserContext<News>();
            context.setData(news);
            this.processerChain.process(context);
        }
        Date lastModifyTime = ((News)list.get(list.size() - 1)).getAddTime();
        this.redisStringAdapter.set(RedisKey.SPIDER_PHP_SYNC, (Object)lastModifyTime);
        this.execute(lastModifyTime);
    }
}

