/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.service;

import com.bxm.localnews.constant.RedisKey;
import com.bxm.localnews.processer.ProcesserChain;
import com.bxm.localnews.processer.ProcesserContext;
import com.bxm.localnews.sync.second.dao.SpiderVideoMapper;
import com.bxm.localnews.sync.vo.spider.SpiderVideo;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VideoSyncService {
    private static final Logger logger = LoggerFactory.getLogger(VideoSyncService.class);
    private final RedisStringAdapter redisStringAdapter;
    private final SpiderVideoMapper spiderVideoMapper;
    private final ProcesserChain processerChain;

    @Autowired
    public VideoSyncService(RedisStringAdapter redisStringAdapter, SpiderVideoMapper spiderVideoMapper, ProcesserChain processerChain) {
        this.redisStringAdapter = redisStringAdapter;
        this.spiderVideoMapper = spiderVideoMapper;
        this.processerChain = processerChain;
    }

    public void sync() {
        Date lastSyncTime = (Date)this.redisStringAdapter.get(RedisKey.SPIDER_VIDEO_SYNC, Date.class);
        if (null == lastSyncTime) {
            Calendar calendar = Calendar.getInstance();
            calendar.add(6, -14);
            lastSyncTime = calendar.getTime();
        }
        this.excute(lastSyncTime);
    }

    private void excute(Date limitDate) {
        List list = this.spiderVideoMapper.listForSync(limitDate, Integer.valueOf(1));
        if (list == null || list.isEmpty()) {
            return;
        }
        for (SpiderVideo video : list) {
            ProcesserContext<SpiderVideo> context = new ProcesserContext<SpiderVideo>();
            context.setData(video);
            this.processerChain.process(context);
        }
        SpiderVideo spiderVideo = (SpiderVideo)list.get(list.size() - 1);
        this.redisStringAdapter.set(RedisKey.SPIDER_VIDEO_SYNC, (Object)spiderVideo.getModifyTime());
        this.excute(spiderVideo.getModifyTime());
    }
}

