/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.service;

import com.bxm.localnews.constant.RedisKey;
import com.bxm.localnews.processer.ProcesserChain;
import com.bxm.localnews.processer.ProcesserContext;
import com.bxm.localnews.sync.second.dao.SpiderWechatNewsMapper;
import com.bxm.localnews.sync.vo.spider.SpiderWechatNews;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WechatNewsSyncService {
    private static final Logger logger = LoggerFactory.getLogger(WechatNewsSyncService.class);
    private final SpiderWechatNewsMapper spiderWechatNewsMapper;
    private final RedisStringAdapter redisStringAdapter;
    private final ProcesserChain processerChain;

    @Autowired
    public WechatNewsSyncService(SpiderWechatNewsMapper spiderWechatNewsMapper, RedisStringAdapter redisStringAdapter, ProcesserChain processerChain) {
        this.spiderWechatNewsMapper = spiderWechatNewsMapper;
        this.redisStringAdapter = redisStringAdapter;
        this.processerChain = processerChain;
    }

    public void sync() {
        Date lastSyncTime = (Date)this.redisStringAdapter.get(RedisKey.SPIDER_WECHAT_SYNC, Date.class);
        if (null == lastSyncTime) {
            Calendar calendar = Calendar.getInstance();
            calendar.add(6, -14);
            lastSyncTime = calendar.getTime();
        }
        this.excute(lastSyncTime);
    }

    private void excute(Date limitDate) {
        List list = this.spiderWechatNewsMapper.listForSync(limitDate);
        if (list == null || list.isEmpty()) {
            logger.debug("list empty return;");
            return;
        }
        for (SpiderWechatNews wechatNews : list) {
            wechatNews.setContent(this.spiderWechatNewsMapper.findById(wechatNews.getId()));
            ProcesserContext<SpiderWechatNews> context = new ProcesserContext<SpiderWechatNews>();
            context.setData(wechatNews);
            this.processerChain.process(context);
        }
        SpiderWechatNews wechatNews = (SpiderWechatNews)list.get(list.size() - 1);
        this.redisStringAdapter.set(RedisKey.SPIDER_WECHAT_SYNC, (Object)wechatNews.getModifyTime());
        this.excute(wechatNews.getModifyTime());
    }
}

