/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.service.impl;

import com.bxm.localnews.service.SyncNewContentService;
import com.bxm.localnews.spider.sync.feign.NewsSearchFeignService;
import com.bxm.localnews.sync.dto.ESNewsContentDTO;
import com.bxm.localnews.sync.third.dao.TnewsMapper;
import com.bxm.localnews.sync.vo.local.ContentNew;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class SyncNewContentServiceImpl
implements SyncNewContentService {
    private static final Logger log = LoggerFactory.getLogger(SyncNewContentServiceImpl.class);
    @Autowired
    private NewsSearchFeignService newsSearchFeignService;
    @Autowired
    private TnewsMapper tnewsMapper;

    @Override
    public void sync() {
        List noContentNews = this.tnewsMapper.findNoContentNews();
        noContentNews.forEach(e -> this.addContentNew((ContentNew)e));
    }

    public void addContentNew(ContentNew contentNew) {
        ResponseEntity entity = this.newsSearchFeignService.get(new Long[]{contentNew.getId()});
        if (Objects.isNull(entity)) {
            log.info("\u8c03\u7528\u641c\u7d22\u5f15\u64ce\u65b0\u95fb\u5185\u5bb9\u5931\u8d25!");
            return;
        }
        List body = (List)entity.getBody();
        if (Objects.isNull(body) || body.isEmpty()) {
            log.info("\u65b0\u95fb\u5185\u5bb9\u4e3a\u7a7a;\u65b0\u95fb\u5185\u5bb9\u4e3a:{}", (Object)((List)entity.getBody()).toString());
        } else {
            ESNewsContentDTO dto = (ESNewsContentDTO)body.get(0);
            contentNew.setContent(dto.getContent());
        }
        this.tnewsMapper.insertContentNews(contentNew);
    }
}

