package com.bxm.localnews.sync.task;


import java.util.Date;

import javax.annotation.Resource;

import com.bxm.localnews.service.MixRecommendPoolService;
import com.bxm.localnews.service.NewsCleanService;
import com.bxm.newidea.component.quartz.AbstractCustomJob;
import com.bxm.newidea.component.vo.Message;

import org.quartz.DisallowConcurrentExecution;
import org.springframework.stereotype.Component;


@Component
@DisallowConcurrentExecution
public class CleanNewsJob extends AbstractCustomJob {

    @Resource
    private NewsCleanService newsCleanService;

    @Resource
    private MixRecommendPoolService mixRecommendPoolService;

    public CleanNewsJob() {
        super("CleanNewsJob", "0 0 3 * * ?", "新闻推荐池定期清理任务");
    }

    @Override
    public Message service() {
        logger.info("开始定时清理新闻!当前时间：{}", new Date());
        this.newsCleanService.clean();
        this.mixRecommendPoolService.clean();
        return Message.build();
    }

}
